package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.flow.ControlFlowNode;
import net.covers1624.coffeegrinder.bytecode.insns.*;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformer;
import net.covers1624.quack.collection.FastStream;

import java.util.LinkedList;
import java.util.List;

/**
 * Created by covers1624 on 9/8/21.
 */
public class SwitchDetection implements BlockTransformer {

    @SuppressWarnings ("NotNullFieldNotInitialized")
    private BlockTransformContext ctx;

    @Override
    public void transform(Block block, BlockTransformContext ctx) {
        this.ctx = ctx;

        Instruction last = block.instructions.lastOrDefault();
        if (last instanceof SwitchTable) {
            transformSwitch(block, (SwitchTable) last);
        }
    }

    private void transformSwitch(Block block, SwitchTable switchTable) {
        ControlFlowNode entryPoint = ctx.getControlFlowNode();

        LinkedList<Block> blocks = getSwitchBlocks(entryPoint);

        BlockContainer switchContainer = new BlockContainer();
        Block newEntryPoint = new Block(block.getSubName("switch")).withOffsets(switchTable);
        newEntryPoint.instructions.add(switchTable);
        blocks.addFirst(newEntryPoint);

        block.instructions.add(new Switch(switchTable.getValue(), switchContainer).withOffsets(switchTable));
        switchTable.setValue(new Nop());

        TransformerUtils.moveBlocksIntoContainer(blocks, (BlockContainer) block.getParent(), switchContainer, null);
    }

    private LinkedList<Block> getSwitchBlocks(ControlFlowNode entryPoint) {
        List<ControlFlowNode> cases = entryPoint.getSuccessors();
        ControlFlowNode lastCase = cases.getLast();

        // If the last case has multiple predecessors, it's probably the break; target
        // We should leave it out in case someone else needs it (and because it looks nice)
        // If we're wrong, ExitPointCleanup will bring it back in
        ControlFlowNode exitNode = lastCase.getPredecessors().size() > 1 ? lastCase : null;

        return FastStream.of(cases)
                .filter(c -> c != exitNode)
                .flatMap(this::getCaseContents)
                .map(e -> e.block)
                .toLinkedList();
    }

    // TODO FastStream.takeWhile
    private FastStream<ControlFlowNode> getCaseContents(ControlFlowNode caseNode) {
        var nodes = new LinkedList<ControlFlowNode>();
        var cfg = ctx.getControlFlowGraph().cfg;
        for (int i = caseNode.cfgIndex; i < cfg.length && caseNode.dominates(cfg[i]); i++) {
            nodes.add(cfg[i]);
        }

        return FastStream.of(nodes);
    }
}
