/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.Cast;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.bytecode.insns.FieldDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.InvokeDynamic;
import net.covers1624.coffeegrinder.bytecode.insns.LoadThis;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.MethodReference;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.ParameterVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Return;
import net.covers1624.coffeegrinder.bytecode.matching.BoxingMatching;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformer;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.quack.collection.ColUtils;
import org.objectweb.asm.Type;

public class Lambdas
implements ClassTransformer {
    private final ClassType lambdaMetaFactory;
    private ClassTransformContext ctx;
    private final Set<Instruction> visited = new HashSet<Instruction>();

    public Lambdas(TypeResolver typeResolver) {
        this.lambdaMetaFactory = typeResolver.resolveClassDecl("java/lang/invoke/LambdaMetafactory");
    }

    @Override
    public void transform(ClassDecl cInsn, ClassTransformContext ctx) {
        this.ctx = ctx;
        this.visited.clear();
        MethodDecl deserializeLambdaDef = cInsn.findMethod("$deserializeLambda$", Type.getMethodType((String)"(Ljava/lang/invoke/SerializedLambda;)Ljava/lang/Object;"));
        if (deserializeLambdaDef != null) {
            ctx.pushStep("Remove $deserializeLambda$ function.");
            deserializeLambdaDef.remove();
            ctx.popStep();
        }
        ImmutableMap syntheticMethods = cInsn.getMethodMembers().filter(e -> e.getMethod().isSynthetic()).toImmutableMap(MethodDecl::getMethod, e -> e);
        ctx.pushStep("Inline lambdas");
        for (FieldDecl field : cInsn.getFieldMembers()) {
            this.visitMember(field, (Map<Method, MethodDecl>)syntheticMethods);
        }
        for (MethodDecl method : cInsn.getMethodMembers().toLinkedList()) {
            this.visitMember(method, (Map<Method, MethodDecl>)syntheticMethods);
        }
        ctx.popStep();
    }

    private void visitMember(Instruction toVisit, Map<Method, MethodDecl> syntheticMethods) {
        if (!this.visited.add(toVisit)) {
            return;
        }
        if (!toVisit.isConnected()) {
            return;
        }
        for (InvokeDynamic invokeDynamic : toVisit.descendantsOfType(InvokeDynamic.class)) {
            if (InvokeMatching.matchInvokeDynamic(invokeDynamic, this.lambdaMetaFactory) == null) continue;
            Method lambdaMethod = (Method)invokeDynamic.bootstrapArguments[1];
            if (!lambdaMethod.isSynthetic()) {
                assert (invokeDynamic.arguments.size() <= 1);
                this.ctx.pushStep("Produce method reference");
                invokeDynamic.replaceWith(new MethodReference((ClassType)invokeDynamic.getResultType(), lambdaMethod, (Instruction)invokeDynamic.arguments.onlyOrDefault(new Nop())).withOffsets(invokeDynamic));
                this.ctx.popStep();
                continue;
            }
            MethodDecl lambdaTarget = syntheticMethods.get(lambdaMethod);
            if (lambdaTarget == null || this.convertLambdaToMethodReference(invokeDynamic, lambdaTarget)) continue;
            this.ctx.pushStep("inline lambda " + lambdaMethod.getName());
            this.visitMember(lambdaTarget, syntheticMethods);
            invokeDynamic.replaceWith(lambdaTarget);
            lambdaTarget.setResultType((ReferenceType)invokeDynamic.getResultType());
            HashMap<ParameterVariable, Instruction> replacements = new HashMap<ParameterVariable, Instruction>();
            int indyArgOffset = 0;
            if (!lambdaMethod.isStatic()) {
                assert (invokeDynamic.arguments.first() instanceof LoadThis);
                ++indyArgOffset;
            }
            for (int i = 0; i < invokeDynamic.arguments.size() - indyArgOffset; ++i) {
                Instruction arg = invokeDynamic.arguments.get(i + indyArgOffset);
                assert (LoadStoreMatching.matchLoadLocal(arg) != null || LoadStoreMatching.matchLoadField(arg) != null);
                ParameterVariable param = lambdaTarget.parameters.get(i);
                assert (param.getStoreCount() == 0);
                replacements.put(param, arg);
            }
            lambdaTarget.descendantsMatching(LoadStoreMatching::matchLoadLocal).forEach(load -> {
                Instruction replacement = (Instruction)replacements.get(load.getVariable());
                if (replacement != null) {
                    load.replaceWith(replacement.copy());
                }
            });
            replacements.keySet().forEach(ParameterVariable::makeImplicit);
            this.ctx.popStep();
        }
    }

    private boolean convertLambdaToMethodReference(InvokeDynamic invokeDynamic, MethodDecl lambdaTarget) {
        Invoke invoke;
        Instruction toMatch;
        Method lambdaMethod = lambdaTarget.getMethod();
        if (!lambdaMethod.isStatic()) {
            return false;
        }
        if (lambdaTarget.getBody().blocks.size() != 1) {
            return false;
        }
        if (invokeDynamic.arguments.size() > 1) {
            return false;
        }
        Block bodyBlock = (Block)lambdaTarget.getBody().blocks.first();
        if (bodyBlock.instructions.size() == 1) {
            Object object = bodyBlock.instructions.first();
            if (!(object instanceof Return)) {
                return false;
            }
            Return ret = (Return)object;
            toMatch = ret.getFirstChild();
        } else {
            toMatch = (Instruction)bodyBlock.instructions.first();
            if (toMatch.getNextSiblingOrNull() != bodyBlock.instructions.last()) {
                return false;
            }
        }
        if (toMatch instanceof Cast) {
            toMatch = toMatch.getFirstChild();
        }
        if ((invoke = BoxingMatching.matchBoxing(toMatch)) instanceof Invoke) {
            Invoke box = invoke;
            toMatch = (Instruction)box.getArguments().only();
        } else {
            invoke = BoxingMatching.matchUnboxing(toMatch);
            if (invoke instanceof Invoke) {
                Invoke unbox = invoke;
                toMatch = unbox.getTarget();
            }
        }
        if (!(toMatch instanceof Invoke)) {
            return false;
        }
        Invoke invoke2 = (Invoke)toMatch;
        if (!invoke2.getMethod().getAccessFlags().get(AccessFlag.PROTECTED) && !invoke2.getMethod().getDeclaringClass().getAccessFlags().get(AccessFlag.PROTECTED)) {
            return false;
        }
        if (invoke2.getMethod().getDeclaringClass().getPackage().equals(lambdaTarget.getMethod().getDeclaringClass().getPackage())) {
            return false;
        }
        ArrayList parameters = lambdaTarget.parameters.toList();
        if (invoke2.getMethod().isStatic() && !parameters.isEmpty() && !ColUtils.anyMatch((Iterable)parameters, e -> e.getName().startsWith("x$"))) {
            return false;
        }
        this.ctx.pushStep("Convert lambda to method reference");
        invokeDynamic.replaceWith(new MethodReference((ClassType)invokeDynamic.getResultType(), invoke2.getTargetClassType(), invoke2.getMethod(), (Instruction)invokeDynamic.arguments.onlyOrDefault(new Nop())).withOffsets(invokeDynamic));
        lambdaTarget.remove();
        this.ctx.popStep();
        return true;
    }
}

