/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.ArrayList;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.Switch;
import net.covers1624.coffeegrinder.bytecode.insns.Yield;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.quack.collection.ColUtils;

public class SwitchExpressions
implements BlockTransformer {
    @Override
    public void transform(Block block, BlockTransformContext ctx) {
        Instruction last = (Instruction)block.instructions.lastOrDefault();
        if (last instanceof Switch) {
            Switch swtch = (Switch)last;
            this.transform(swtch, (MethodTransformContext)ctx);
        }
    }

    private void transform(Switch swtch, MethodTransformContext ctx) {
        record Candidate(Branch exit, Store store) {
        }
        ArrayList matches = swtch.descendantsOfType(Branch.class).filter(e -> !e.getTargetBlock().isDescendantOf(swtch)).map(suspect -> {
            Store patt0$temp = LoadStoreMatching.matchStoreLocal(suspect.getPrevSiblingOrNull());
            if (!(patt0$temp instanceof Store)) {
                return null;
            }
            Store store = patt0$temp;
            if (store.getVariable().getKind() != LocalVariable.VariableKind.STACK_SLOT) {
                return null;
            }
            return new Candidate((Branch)suspect, store);
        }).filter(Objects::nonNull).toList();
        if (matches.isEmpty()) {
            return;
        }
        Candidate firstMatch = (Candidate)matches.getFirst();
        Branch target = firstMatch.exit;
        LocalVariable var = firstMatch.store.getVariable();
        if (var.getLoadCount() != 1) {
            return;
        }
        if (!ColUtils.allMatch((Iterable)matches, c -> c.exit.getTargetBlock() == target.getTargetBlock() && c.store.getVariable() == var)) {
            return;
        }
        ctx.pushStep("Produce switch expression.");
        Switch newSwitch = new Switch(swtch.getValue(), swtch.getBody(), var.getType());
        for (Candidate match : matches) {
            assert (match != null);
            match.exit.replaceWith(new Yield(newSwitch, match.store.getValue()).withOffsets(match.exit));
            match.store.remove();
        }
        Store store = swtch.replaceWith(new Store(new LocalReference(var), newSwitch));
        store.insertAfter(new Branch(target.getTargetBlock()));
        ctx.popStep();
    }
}

