/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.util;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static <T> void reverse(List<T> list) {
        int i = 0;
        for (int j = list.size() - 1; i < j; ++i, --j) {
            T tmp = list.get(i);
            list.set(i, list.get(j));
            list.set(j, tmp);
        }
    }

    public static <T> Iterable<T> safeConcat(@Nullable List<T> a, @Nullable List<T> b) {
        if (a != null && b != null) {
            return FastStream.concat((Iterable[])new Iterable[]{a, b});
        }
        return a == null ? (b != null ? b : FastStream.of()) : a;
    }

    public static <T> Supplier<T> singleMemoize(Supplier<T> supplier) {
        AtomicBoolean hit = new AtomicBoolean();
        return Suppliers.memoize(() -> {
            if (hit.get()) {
                throw new RuntimeException("Memoized supplier re-enterance detected.");
            }
            hit.set(true);
            return supplier.get();
        });
    }

    public static <T> int indexOf(Iterable<? extends T> things, Predicate<? super T> pred) {
        int i = 0;
        for (T thing : things) {
            if (pred.test(thing)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

