/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.ArrayList;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.TryCatch;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;
import net.covers1624.coffeegrinder.util.None;
import org.jetbrains.annotations.Nullable;

public class TryCatchMerging
implements MethodTransformer {
    @Override
    public void transform(MethodDecl function, MethodTransformContext ctx) {
        TryCatchMerging.fixJavacFinallyExHandlerEntryInTryRangeBug(function, ctx);
        TryCatchMerging.mergeSplitTries(function, ctx);
    }

    private static void fixJavacFinallyExHandlerEntryInTryRangeBug(MethodDecl function, MethodTransformContext ctx) {
        function.descendantsToList(TryCatch.TryCatchHandler.class).forEach(handler -> {
            TryCatch tryCatch = (TryCatch)handler.getParent();
            Block inBlock = (Block)tryCatch.getParent();
            Block target = TryCatchMerging.getHandlerTarget(handler);
            if (!target.isDescendantOf(tryCatch)) {
                return;
            }
            assert (((TryCatch.TryCatchHandler)tryCatch.handlers.only()).isUnprocessedFinally);
            assert (!target.hasFlag(InstructionFlag.MAY_THROW));
            if (tryCatch.getTryBody().blocks.size() == 1) {
                ctx.pushStep("Unwrap redundant try-finally");
                inBlock.instructions.addAllFirst((Iterable<Instruction>)((Object)((Block)tryCatch.getTryBody().blocks.only()).instructions));
                tryCatch.remove();
                ctx.popStep();
            } else {
                ctx.pushStep("Move finally handler entry block out of try range");
                inBlock.insertAfter(target);
                ctx.popStep();
            }
        });
    }

    private static void mergeSplitTries(MethodDecl function, MethodTransformContext ctx) {
        function.accept(new SimpleInsnVisitor<MethodTransformContext>(){

            @Override
            public None visitDefault(Instruction insn, MethodTransformContext ctx) {
                for (Instruction child = insn.getFirstChildOrNull(); child != null; child = child.getNextSiblingOrNull()) {
                    assert (child.getParent() == insn);
                    child.accept(this, ctx);
                }
                return NONE;
            }

            @Override
            public None visitTryCatch(TryCatch tryCatch, MethodTransformContext ctx) {
                TryCatchMerging.mergeSplitTries(tryCatch, ctx);
                return (None)super.visitTryCatch(tryCatch, ctx);
            }
        }, ctx);
    }

    private static void mergeSplitTries(TryCatch first, MethodTransformContext ctx) {
        Block target = TryCatchMerging.getHandlerTarget((TryCatch.TryCatchHandler)first.handlers.only());
        ArrayList tryCatches = target.getBranches().map(TryCatchMerging::matchTryCatchHandlerBranch).filterNonNull().filter(tc -> tc != first).toList();
        if (tryCatches.isEmpty()) {
            return;
        }
        BlockContainer firstBody = first.getTryBody();
        for (TryCatch toProcess : tryCatches) {
            Block inBlock = (Block)toProcess.getParent();
            if (!inBlock.getBranches().allMatch(e -> e.isDescendantOf(firstBody))) {
                return;
            }
            ctx.pushStep("Merge split try-catch " + ((Block)toProcess.getParent()).getName() + " dominated by first " + ((Block)first.getParent()).getName());
            ArrayList branchesToCheck = toProcess.getTryBody().descendantsOfType(Branch.class).toList();
            Block toProcessEntry = toProcess.getTryBody().getEntryPoint();
            toProcessEntry.getBranches().toList().forEach(br -> br.setTargetBlock(inBlock));
            inBlock.instructions.addAll((Iterable<Instruction>)((Object)toProcessEntry.instructions));
            toProcessEntry.remove();
            firstBody.blocks.add(inBlock);
            firstBody.blocks.addAll((Iterable<Block>)((Object)toProcess.getTryBody().blocks));
            toProcess.remove();
            branchesToCheck.forEach(b -> {
                while (b.isDescendantOf(b.getTargetBlock()) && b.getTargetBlock() != inBlock) {
                    TryCatch tryCatch = (TryCatch)b.getTargetBlock().getFirstChild();
                    b.setTargetBlock(tryCatch.getTryBody().getEntryPoint());
                }
            });
            ctx.popStep();
        }
    }

    @Nullable
    private static TryCatch matchTryCatchHandlerBranch(Branch branch) {
        Instruction instruction = branch.getParent().getParent().getParent();
        if (!(instruction instanceof TryCatch.TryCatchHandler)) {
            return null;
        }
        TryCatch.TryCatchHandler h = (TryCatch.TryCatchHandler)instruction;
        return (TryCatch)h.getParent();
    }

    private static Block getHandlerTarget(TryCatch.TryCatchHandler handler) {
        return ((Branch)handler.getBody().getEntryPoint().getFirstChild()).getTargetBlock();
    }
}

