/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.Iterator;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.InstanceOf;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LogicNot;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.RecordPattern;
import net.covers1624.coffeegrinder.bytecode.insns.Switch;
import net.covers1624.coffeegrinder.bytecode.insns.SwitchTable;
import net.covers1624.coffeegrinder.bytecode.insns.tags.SwitchRecordPatternTag;
import net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching;
import net.covers1624.coffeegrinder.bytecode.matching.IfMatching;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.ConditionDetection;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.statement.ExpressionTransforms;

public class SwitchInlining
implements BlockTransformer {
    @Override
    public void transform(Block block, BlockTransformContext ctx) {
        Instruction instruction = block.getFirstChild();
        if (instruction instanceof SwitchTable) {
            SwitchTable switchTable = (SwitchTable)instruction;
            BlockContainer switchContainer = (BlockContainer)block.getParent();
            ctx.pushStep("Inline switch sections " + switchContainer.getEntryPoint().getName());
            Iterator<SwitchTable.SwitchSection> iterator = switchTable.sections.iterator();
            while (iterator.hasNext()) {
                Branch branch;
                Block target;
                SwitchTable.SwitchSection section = iterator.next();
                Instruction instruction2 = section.getBody();
                if (!(instruction2 instanceof Branch) || (target = (branch = (Branch)instruction2).getTargetBlock()).getIncomingEdgeCount() != 1) continue;
                ctx.pushStep("Inline section");
                branch.replaceWith(target);
                Object object = section.values.onlyOrDefault();
                if (object instanceof SwitchTable.SwitchPattern) {
                    SwitchTable.SwitchPattern pattern = (SwitchTable.SwitchPattern)object;
                    this.captureRecordPattern(pattern, target, ctx);
                    this.capturePatternGuard(pattern, target, ctx);
                }
                ctx.popStep();
                object = section.getNextSiblingOrNull();
                if (object instanceof SwitchTable.SwitchSection) {
                    SwitchTable.SwitchSection nextSection = (SwitchTable.SwitchSection)object;
                    if (target.instructions.count() > 1 && BranchLeaveMatching.compatibleExitInstruction(target.getLastChild(), nextSection.getBody())) {
                        ctx.pushStep("Create fallthrough");
                        target.getLastChild().remove();
                        ctx.popStep();
                        continue;
                    }
                }
                ConditionDetection.tryUnwrap(target, ctx);
            }
            ctx.popStep();
        }
    }

    private void captureRecordPattern(SwitchTable.SwitchPattern pattern, Block body, BlockTransformContext ctx) {
        Instruction instruction = pattern.getPattern();
        if (!(instruction instanceof LocalReference)) {
            return;
        }
        LocalReference patternRef = (LocalReference)instruction;
        if (!(patternRef.variable.getTag() instanceof SwitchRecordPatternTag)) {
            return;
        }
        ctx.pushStep("Capture record pattern");
        IfInstruction patternIf = (IfInstruction)body.getFirstChild();
        ConditionDetection.invertIf(patternIf, ctx);
        LogicNot inversion = (LogicNot)patternIf.getCondition();
        InstanceOf patternInstanceof = (InstanceOf)inversion.getArgument();
        assert (patternInstanceof.getPattern() instanceof RecordPattern);
        assert (patternIf.getTrueInsn() instanceof Switch.SwitchGuard);
        assert (patternIf.getFalseInsn() instanceof Nop);
        pattern.getPattern().replaceWith(patternInstanceof.getPattern());
        patternIf.remove();
        ctx.popStep();
    }

    private void capturePatternGuard(SwitchTable.SwitchPattern pattern, Block body, BlockTransformContext ctx) {
        IfInstruction ifInstruction = IfMatching.matchNopFalseIf(body.getFirstChild());
        if (!(ifInstruction instanceof IfInstruction)) {
            return;
        }
        IfInstruction ifInsn = ifInstruction;
        if (!(ifInsn.getTrueInsn() instanceof Switch.SwitchGuard)) {
            if (!(ifInsn.getNextSiblingOrNull() instanceof Switch.SwitchGuard)) {
                return;
            }
            ConditionDetection.invertIf(ifInsn, ctx);
        }
        ctx.pushStep("Capture pattern guard");
        pattern.getCondition().replaceWith(new LogicNot(ifInsn.getCondition()));
        ifInsn.remove();
        ExpressionTransforms.runOnExpression(pattern.getCondition(), ctx);
        ctx.popStep();
    }
}

