/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers.statement;

import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.InvokeDynamic;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.Switch;
import net.covers1624.coffeegrinder.bytecode.matching.LdcMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.PrepareSwitchOnType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public class FinishSwitchOnType
implements StatementTransformer {
    @Nullable
    private final ClassType switchBootstraps;

    public FinishSwitchOnType(TypeResolver resolver) {
        this.switchBootstraps = resolver.tryResolveClassDecl("java/lang/runtime/SwitchBootstraps");
    }

    @Override
    public void transform(Instruction statement, StatementTransformContext ctx) {
        if (this.switchBootstraps == null) {
            return;
        }
        Store store = LoadStoreMatching.matchStoreLocal(statement);
        if (!(store instanceof Store)) {
            return;
        }
        Store selVarStore = store;
        LocalVariable pattVar = selVarStore.getVariable();
        Store store2 = LoadStoreMatching.matchStoreLocal(selVarStore.getNextSiblingOrNull());
        if (!(store2 instanceof Store)) {
            return;
        }
        Store indexVarStore = store2;
        LocalVariable indexVar = indexVarStore.getVariable();
        if (LdcMatching.matchLdcInt(indexVarStore.getValue(), 0) == null) {
            return;
        }
        Switch swtch = this.matchPatternSwitchDecl(indexVarStore.getNextSiblingOrNull(), pattVar, indexVar);
        if (swtch == null) {
            return;
        }
        assert (indexVar.getLoadCount() == 1);
        assert (pattVar.getLoadCount() == 1);
        ctx.pushStep("Cleanup switch-on-type " + swtch.getBody().getEntryPoint().getName());
        swtch.getValue().replaceWith(selVarStore.getValue());
        selVarStore.remove();
        indexVarStore.remove();
        ctx.popStep();
    }

    @Nullable
    private Switch matchPatternSwitchDecl(@Nullable Instruction insn, LocalVariable pattVar, LocalVariable indexVar) {
        Switch swtch;
        if (insn instanceof Switch) {
            Switch swtch2 = (Switch)insn;
            if (this.matchTypeSwitchIndy(swtch2.getValue(), pattVar, indexVar) == null) {
                return null;
            }
            return swtch2;
        }
        Instruction indyCandidate = (Instruction)FastStream.of(pattVar.getReferences()).filter(e -> e.isDescendantOf(insn)).map(e -> LoadStoreMatching.matchLoadLocal(e.getParent(), pattVar)).filter(Objects::nonNull).map(e -> this.matchTypeSwitchIndy(e.getParent(), pattVar, indexVar)).filter(Objects::nonNull).onlyOrDefault();
        if (indyCandidate == null) {
            return null;
        }
        Instruction instruction = indyCandidate.getParent();
        return instruction instanceof Switch ? (swtch = (Switch)instruction) : null;
    }

    @Nullable
    private InvokeDynamic matchTypeSwitchIndy(Instruction insn, LocalVariable pattVar, LocalVariable indexVar) {
        InvokeDynamic indy = PrepareSwitchOnType.matchTypeSwitchIndy(insn, Objects.requireNonNull(this.switchBootstraps));
        if (indy == null) {
            return null;
        }
        if (LoadStoreMatching.matchLoadLocal(indy.arguments.get(0), pattVar) == null) {
            return null;
        }
        if (LoadStoreMatching.matchLoadLocal(indy.arguments.get(1), indexVar) == null) {
            return null;
        }
        return indy;
    }
}

