package net.covers1624.coffeegrinder.bytecode.transform;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.Leave;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.ConditionDetection;

import static net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching.matchBranch;
import static net.covers1624.quack.util.SneakyUtils.trueP;

/**
 * Created by covers1624 on 5/12/22.
 */
public class LabelledBlocks implements BlockTransformer {

    @Override
    public void transform(Block block, BlockTransformContext ctx) {
        while (makeLabelledBreakContainer(block, ctx)) ;
    }

    private boolean makeLabelledBreakContainer(Block block, BlockTransformContext ctx) {
        Block nextBlock = (Block) block.getNextSiblingOrNull();
        if (nextBlock == null) return false;
        if (!nextBlock.getBranches().allMatch(b -> b.isDescendantOf(block))) return false;

        ctx.pushStep("Wrap with container");
        BlockContainer cont = new BlockContainer();

        Instruction first = block.instructions.filter(i -> i.descendantsMatching(e -> matchBranch(e, nextBlock)).anyMatch(trueP())).first();
        Block nested = block.extractRange(nextBlock.getName(), first, block.getLastChild());
        cont.blocks.add(nested);
        block.instructions.add(cont);

        ctx.pushStep("Rewrite branches to leaves");
        for (Branch b : nextBlock.getBranches().toList()) {
            b.replaceWith(new Leave(cont));
        }
        block.instructions.add(new Branch(nextBlock));
        ctx.popStep();

        ctx.popStep();
        ConditionDetection.inlineExitBranch(block, ctx);

        return true;
    }
}
