package net.covers1624.coffeegrinder.bytecode.transform.transformers.statement;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.InstanceOf;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LogicAnd;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.tags.RecordPatternComponentTag;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformer;
import net.covers1624.coffeegrinder.util.None;
import net.covers1624.quack.collection.FastStream;

import static net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching.matchLoadLocal;

/**
 * Created by covers1624 on 12/12/25.
 */
public class RecordPatternSimplification extends SimpleInsnVisitor<StatementTransformContext> implements StatementTransformer {

    @Override
    public void transform(Instruction statement, StatementTransformContext ctx) {
        statement.accept(this, ctx);
    }

    @Override
    public None visitLogicAnd(LogicAnd logicAnd, StatementTransformContext ctx) {
        super.visitLogicAnd(logicAnd, ctx);

        if (tryInline(logicAnd.getLeft(), logicAnd.getRight(), ctx)) return NONE;
        if (tryInline(logicAnd.getRight(), logicAnd.getLeft(), ctx)) return NONE;
        return NONE;
    }

    private boolean tryInline(Instruction target, Instruction remainder, StatementTransformContext ctx) {
        if (!(target instanceof InstanceOf instanceOf) || (instanceOf.getPattern() instanceof Nop)) return false;
        if (!(matchLoadLocal(instanceOf.getArgument()) instanceof Load load) || !(load.getTag() instanceof RecordPatternComponentTag)) return false;

        var otherRef = FastStream.of(load.getVariable().getReferences())
                .filter(e -> e != load.getReference())
                .only();
        ctx.pushStep("Inline nested record pattern");
        otherRef.replaceWith(instanceOf.getPattern());
        target.getParent().replaceWith(remainder);
        ctx.popStep();
        return true;
    }
}
