package net.covers1624.coffeegrinder.type;

import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

import java.util.Map;

/**
 * Created by covers1624 on 12/4/21.
 */
public class PrimitiveType extends AType {

    public static final PrimitiveType VOID = new PrimitiveType("void", Type.VOID_TYPE, Void.class, null);
    public static final PrimitiveType BOOLEAN = new PrimitiveType("boolean", Type.BOOLEAN_TYPE, Boolean.class, "booleanValue");
    public static final PrimitiveType CHAR = new PrimitiveType("char", Type.CHAR_TYPE, Character.class, "charValue");
    public static final PrimitiveType BYTE = new PrimitiveType("byte", Type.BYTE_TYPE, Byte.class, "byteValue");
    public static final PrimitiveType SHORT = new PrimitiveType("short", Type.SHORT_TYPE, Short.class, "shortValue");
    public static final PrimitiveType INT = new PrimitiveType("int", Type.INT_TYPE, Integer.class, "intValue");
    public static final PrimitiveType FLOAT = new PrimitiveType("float", Type.FLOAT_TYPE, Float.class, "floatValue");
    public static final PrimitiveType LONG = new PrimitiveType("long", Type.LONG_TYPE, Long.class, "longValue");
    public static final PrimitiveType DOUBLE = new PrimitiveType("double", Type.DOUBLE_TYPE, Double.class, "doubleValue");

    public static final PrimitiveType[] PRIMITIVE_TYPES = new PrimitiveType[] {
            VOID,
            BOOLEAN,
            CHAR,
            BYTE,
            SHORT,
            INT,
            FLOAT,
            LONG,
            DOUBLE
    };

    public static final Map<String, PrimitiveType> UNBOX_LOOKUP = FastStream.of(PRIMITIVE_TYPES)
            .toImmutableMap(e -> e.getBoxedClass().getName(), e -> e);

    private final String name;
    private final Type type;
    private final Class<?> boxedClass;
    private final @Nullable String unboxMethodName;

    private PrimitiveType(String name, Type type, Class<?> boxedClass, @Nullable String unboxMethodName) {
        this.name = name;
        this.type = type;
        this.boxedClass = boxedClass;
        this.unboxMethodName = unboxMethodName;
    }

    @Override
    public String getName() {
        return name;
    }

    public Type getDescriptor() {
        return type;
    }

    public Class<?> getBoxedClass() {
        return boxedClass;
    }

    public String getUnboxMethodName() {
        if (unboxMethodName == null) throw new UnsupportedOperationException("Void does not have an unboxing method name.");

        return unboxMethodName;
    }

    public String getBoxMethodName() {
        return "valueOf";
    }

    @Override
    public String toString() {
        return "PrimitiveType(" + name + ")";
    }
}
