/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.testengine.testcase.target;

import com.google.common.collect.ImmutableMap;
import io.codechicken.diffpatch.cli.CliOperation;
import io.codechicken.diffpatch.cli.DiffOperation;
import io.codechicken.diffpatch.diff.LineMatchedDiffer;
import io.codechicken.diffpatch.util.Input;
import io.codechicken.diffpatch.util.Output;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.covers1624.coffeegrinder.testengine.api.RoundTripIgnore;
import net.covers1624.coffeegrinder.testengine.api.Target;
import net.covers1624.coffeegrinder.testengine.api.VersionFilter;
import net.covers1624.coffeegrinder.testengine.testcase.target.TargetStepDescriptor;
import net.covers1624.coffeegrinder.testengine.testcase.target.TestCaseDescriptor;
import net.covers1624.coffeegrinder.testengine.testcase.util.OutputPath;
import net.covers1624.coffeegrinder.util.asm.OrderedTextifier;
import net.covers1624.jdkutils.JavaVersion;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.junit.platform.engine.UniqueId;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

public class BytecodeRoundTripTargetStepDescriptor
extends TargetStepDescriptor {
    private static final String IGNORE_ANN_DESC = Type.getDescriptor(RoundTripIgnore.class);

    public BytecodeRoundTripTargetStepDescriptor(UniqueId parentId) {
        super(parentId, Target.BYTECODE_ROUND_TRIP);
    }

    @Override
    public void execute(TestCaseDescriptor testDescriptor) throws Exception {
        Map<String, byte[]> compileOutput = testDescriptor.getCompileOutput();
        ArrayList<ComparisonResult> results = new ArrayList<ComparisonResult>();
        results.add(this.compareClasses(testDescriptor, testDescriptor.inputClass, compileOutput));
        for (Path innerClass : testDescriptor.innerClassPaths) {
            results.add(this.compareClasses(testDescriptor, innerClass, compileOutput));
        }
        if (testDescriptor.root.updateLibraryDefs) {
            for (ComparisonResult result : results) {
                ImmutableMap appliedIgnores = FastStream.of(testDescriptor.testCase.roundTripIgnores.getOrDefault(result.cName, (Map<String, String>)ImmutableMap.of()).entrySet()).filter(e -> result.appliedIgnores.contains(e.getKey())).toImmutableMap(Map.Entry::getKey, Map.Entry::getValue);
                testDescriptor.testCase.appliedRoundTripIgnores.put(result.cName, (Map<String, String>)appliedIgnores);
            }
        }
        if (testDescriptor.outputRTDiff != null) {
            StringBuilder sb = new StringBuilder();
            for (ComparisonResult result : results) {
                try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                    CliOperation.Result r = DiffOperation.builder().baseInput((Input)Input.SingleInput.string((String)result.aNode, (String)(result.cName + ".class"))).changedInput((Input)Input.SingleInput.string((String)result.bNode, (String)(result.cName + ".class"))).patchesOutput((Output)Output.SingleOutput.pipe((OutputStream)bos)).autoHeader(true).differFactory(LineMatchedDiffer::new).build().operate();
                    if (r.exit != 1) continue;
                    sb.append(bos.toString(StandardCharsets.UTF_8));
                }
            }
            if (!sb.isEmpty()) {
                this.unabortable(() -> this.assertRTDiffOutput(testDescriptor.outputRTDiff, sb.toString(), testDescriptor));
            }
        }
        ArrayList<Executable> executables = new ArrayList<Executable>();
        for (ComparisonResult result : results) {
            if (result.redundantIgnores.isEmpty()) continue;
            String message = "Class " + result.cName + " does not require RoundTripIgnore for the following methods anymore.\n\t" + String.join((CharSequence)"\n\t", result.redundantIgnores);
            executables.add(() -> Assertions.fail((String)message));
        }
        for (ComparisonResult result : results) {
            executables.add(() -> Assertions.assertEquals((Object)result.aNode, (Object)result.bNode));
        }
        Assertions.assertAll(executables);
    }

    private ComparisonResult compareClasses(TestCaseDescriptor testDescriptor, Path inputClass, Map<String, byte[]> compOutput) throws IOException {
        Path rel = testDescriptor.inputRoot.relativize(inputClass);
        byte[] compOut = compOutput.remove(rel.toString().replace('\\', '/'));
        Assertions.assertNotNull((Object)compOut, (String)("Class does not exist in compile output: " + String.valueOf(rel)));
        ClassNode aNode = this.parse(Files.readAllBytes(inputClass));
        ClassNode bNode = this.parse(compOut);
        List<String> ignoredMethods = this.collectIgnoredMethods(aNode, testDescriptor.root.referenceJava.langVersion);
        ignoredMethods.addAll(testDescriptor.testCase.getRoundTripIgnores(aNode.name));
        this.cleanupForBytecodeRT(aNode);
        this.cleanupForBytecodeRT(bNode);
        ArrayList<String> redundantIgnores = new ArrayList<String>();
        ArrayList<String> appliedIgnores = new ArrayList<String>();
        for (String key : ignoredMethods) {
            MethodNode aMethod = this.stripMethod(aNode, key);
            MethodNode bMethod = this.stripMethod(bNode, key);
            if (OrderedTextifier.textify((MethodNode)aMethod).equals(OrderedTextifier.textify((MethodNode)bMethod))) {
                redundantIgnores.add(key);
                continue;
            }
            appliedIgnores.add(key);
        }
        return new ComparisonResult(aNode.name, OrderedTextifier.textify((ClassNode)aNode), OrderedTextifier.textify((ClassNode)bNode), redundantIgnores, appliedIgnores);
    }

    private ClassNode parse(byte[] file) {
        ClassNode cNode = new ClassNode();
        ClassReader reader = new ClassReader(file);
        reader.accept((ClassVisitor)cNode, 4);
        if (cNode.nestMembers != null) {
            cNode.nestMembers.sort(Comparator.naturalOrder());
        }
        return cNode;
    }

    private ClassNode cleanupForBytecodeRT(ClassNode cNode) {
        for (MethodNode mNode : cNode.methods) {
            this.stripLineNumbers(mNode);
            this.stripUnusedLabels(mNode);
            this.sortLVTable(mNode);
        }
        return cNode;
    }

    private MethodNode stripMethod(ClassNode cNode, String key) {
        Iterator iterator = cNode.methods.iterator();
        while (iterator.hasNext()) {
            MethodNode method = (MethodNode)iterator.next();
            if (!key.equals(method.name + method.desc)) continue;
            iterator.remove();
            return method;
        }
        throw new IllegalStateException("Method not found: " + key);
    }

    private void stripLineNumbers(MethodNode mNode) {
        ListIterator iterator = mNode.instructions.iterator();
        while (iterator.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)iterator.next();
            if (insn.getType() != 15) continue;
            iterator.remove();
        }
    }

    private void stripUnusedLabels(MethodNode mNode) {
        HashSet<Label> importantLabels = new HashSet<Label>();
        for (TryCatchBlockNode tryCatchBlock : mNode.tryCatchBlocks) {
            importantLabels.add(tryCatchBlock.start.getLabel());
            importantLabels.add(tryCatchBlock.end.getLabel());
            importantLabels.add(tryCatchBlock.handler.getLabel());
        }
        if (mNode.localVariables != null) {
            for (LocalVariableNode localVariable : mNode.localVariables) {
                importantLabels.add(localVariable.start.getLabel());
                importantLabels.add(localVariable.end.getLabel());
            }
        }
        BytecodeRoundTripTargetStepDescriptor.getControlFlowLabels(mNode.instructions).forEach(e -> importantLabels.add(e.getLabel()));
        ListIterator iterator = mNode.instructions.iterator();
        while (iterator.hasNext()) {
            LabelNode labelNode;
            AbstractInsnNode insn = (AbstractInsnNode)iterator.next();
            if (insn.getType() != 8 || (labelNode = (LabelNode)insn).getPrevious() == null || labelNode.getNext() == null || importantLabels.contains(labelNode.getLabel())) continue;
            iterator.remove();
        }
    }

    private void sortLVTable(MethodNode mNode) {
        if (mNode.localVariables == null) {
            return;
        }
        HashMap labelIndexes = new HashMap();
        mNode.instructions.forEach(e -> {
            if (e instanceof LabelNode) {
                LabelNode node = (LabelNode)e;
                labelIndexes.put(node.getLabel(), labelIndexes.size());
            }
        });
        mNode.localVariables.sort(Comparator.comparingInt(e -> labelIndexes.getOrDefault(e.start.getLabel(), 0)).thenComparingInt(e -> labelIndexes.getOrDefault(e.end.getLabel(), 0)).thenComparingInt(e -> e.index).thenComparing(e -> e.name).thenComparing(e -> e.desc));
    }

    private List<String> collectIgnoredMethods(ClassNode cNode, JavaVersion javaVersion) {
        return FastStream.of((Iterable)cNode.methods).filter(mNode -> mNode.visibleAnnotations != null).filter(mNode -> FastStream.of((Iterable)mNode.visibleAnnotations).anyMatch(annotation -> BytecodeRoundTripTargetStepDescriptor.matchesRTIgnore(annotation, javaVersion))).map(e -> e.name + e.desc).toLinkedList();
    }

    private static boolean matchesRTIgnore(AnnotationNode annotation, JavaVersion javaVersion) {
        if (!annotation.desc.equals(IGNORE_ANN_DESC)) {
            return false;
        }
        Object filter = BytecodeRoundTripTargetStepDescriptor.getValue(annotation.values, "filter");
        if (filter == null) {
            return true;
        }
        return VersionFilter.matches((String)filter.toString(), (int)(javaVersion.ordinal() + 1));
    }

    private void assertRTDiffOutput(@Nullable OutputPath.Entry output, String result, TestCaseDescriptor testDescriptor) throws IOException {
        if (output == null) {
            return;
        }
        String prev = output.readOrNull();
        if (testDescriptor.root.updateOutput) {
            if (prev == null || !prev.equals(result)) {
                output.write(result);
            }
            return;
        }
        if (prev == null) {
            Assertions.assertFalse((boolean)testDescriptor.outputMandatory, (String)"Expected prior RT Diff output to exist. Re-run in update mode.");
            return;
        }
        Assertions.assertEquals((Object)prev, (Object)result, (String)"RT Diff changed");
    }

    @Nullable
    private static Object getValue(List<Object> values, String name) {
        int idx = values.indexOf(name);
        if (idx == -1) {
            return null;
        }
        return values.get(idx + 1);
    }

    public static Set<LabelNode> getControlFlowLabels(InsnList list) {
        HashSet<LabelNode> controlFlowLabels = new HashSet<LabelNode>();
        block5: for (AbstractInsnNode insn = list.getFirst(); insn != null; insn = insn.getNext()) {
            switch (insn.getType()) {
                case 7: {
                    JumpInsnNode jinsn = (JumpInsnNode)insn;
                    controlFlowLabels.add(jinsn.label);
                    continue block5;
                }
                case 11: {
                    TableSwitchInsnNode tsinsn = (TableSwitchInsnNode)insn;
                    controlFlowLabels.add(tsinsn.dflt);
                    controlFlowLabels.addAll(tsinsn.labels);
                    continue block5;
                }
                case 12: {
                    LookupSwitchInsnNode lsinsn = (LookupSwitchInsnNode)insn;
                    controlFlowLabels.add(lsinsn.dflt);
                    controlFlowLabels.addAll(lsinsn.labels);
                }
            }
        }
        return controlFlowLabels;
    }

    private record ComparisonResult(String cName, String aNode, String bNode, List<String> redundantIgnores, List<String> appliedIgnores) {
    }
}

