/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.Cast;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.InstanceOf;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.LdcBoolean;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.LogicNot;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.NewObject;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.Throw;
import net.covers1624.coffeegrinder.bytecode.insns.TryCatch;
import net.covers1624.coffeegrinder.bytecode.insns.tags.RecordPatternComponentTag;
import net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LdcMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.TypeResolver;
import org.jetbrains.annotations.Nullable;

public class PrepareRecordPatterns
implements MethodTransformer {
    @Nullable
    private final ClassType c_MatchException;

    public PrepareRecordPatterns(TypeResolver resolver) {
        this.c_MatchException = resolver.tryResolveClassDecl("java/lang/MatchException");
    }

    @Override
    public void transform(MethodDecl function, MethodTransformContext ctx) {
        if (this.c_MatchException == null) {
            return;
        }
        ArrayList matchExceptions = function.descendantsOfType(NewObject.class).map(this::matchRecordPatternMatchExceptionThrow).filterNonNull().toList();
        matchExceptions.forEach(mE -> this.transformFromMatchException((Block)mE, ctx));
    }

    private void transformFromMatchException(Block handlerBlock, MethodTransformContext ctx) {
        LinkedList<Runnable> actions = new LinkedList<Runnable>();
        for (Branch branch : handlerBlock.getBranches()) {
            if (this.matchRecordPropertyRetrieval(branch, actions, ctx)) continue;
            return;
        }
        ctx.pushStep("Process Record Pattern MatchException.");
        actions.forEach(Runnable::run);
        if (handlerBlock.isConnected()) {
            ctx.pushStep("Remove MatchException throw block");
            handlerBlock.remove();
            ctx.popStep();
        }
        ctx.popStep();
    }

    private boolean matchRecordPropertyRetrieval(Branch branch, List<Runnable> actions, MethodTransformContext ctx) {
        Instruction instruction = branch.getParentOrNull();
        if (!(instruction instanceof Block)) {
            return false;
        }
        Block inBlock = (Block)instruction;
        Instruction instruction2 = inBlock.getParentOrNull();
        if (!(instruction2 instanceof BlockContainer)) {
            return false;
        }
        BlockContainer inContainer = (BlockContainer)instruction2;
        Instruction instruction3 = inContainer.getParentOrNull();
        if (!(instruction3 instanceof TryCatch.TryCatchHandler)) {
            return false;
        }
        TryCatch.TryCatchHandler handler = (TryCatch.TryCatchHandler)instruction3;
        TryCatch tryCatch = handler.getTry();
        if (tryCatch.getNextSiblingOrNull() != null) {
            return false;
        }
        BlockContainer body = tryCatch.getTryBody();
        if (body.blocks.size() != 1) {
            return false;
        }
        Instruction instruction4 = body.getEntryPoint().getLastChild();
        if (!(instruction4 instanceof Branch)) {
            return false;
        }
        Branch nextBr = (Branch)instruction4;
        Block tryInside = (Block)tryCatch.getParent();
        if (tryInside != nextBr.getTargetBlock().getPrevSiblingOrNull()) {
            return false;
        }
        Block entry = body.getEntryPoint();
        Store store = LoadStoreMatching.matchStoreLocal(entry.getFirstChild());
        if (!(store instanceof Store)) {
            return false;
        }
        Store valueStore = store;
        if (valueStore.getVariable().getKind() != LocalVariable.VariableKind.STACK_SLOT) {
            return false;
        }
        Invoke invoke = InvokeMatching.matchInvoke(valueStore.getValue(), Invoke.InvokeKind.VIRTUAL);
        if (!(invoke instanceof Invoke)) {
            return false;
        }
        Invoke valueRetriever = invoke;
        if (!valueRetriever.getTargetClassType().isRecord()) {
            return false;
        }
        if (!valueRetriever.getArguments().isEmpty()) {
            return false;
        }
        if (valueStore.getNextSiblingOrNull() != nextBr) {
            return false;
        }
        actions.add(() -> {
            ctx.pushStep("Unwrap record pattern try-catch");
            tryInside.instructions.addAll((Iterable<Instruction>)((Object)((Block)body.blocks.only()).instructions));
            tryCatch.remove();
            valueRetriever.setTag(new RecordPatternComponentTag());
            this.tryReplaceExactConversionWithInstanceOf(nextBr.getTargetBlock(), ctx);
            ctx.popStep();
        });
        return true;
    }

    @Nullable
    private Block matchRecordPatternMatchExceptionThrow(NewObject newObj) {
        Invoke ctorCall;
        Invoke toStringCall;
        if (!newObj.getType().equals(this.c_MatchException)) {
            return null;
        }
        Store store = LoadStoreMatching.matchStoreLocal(newObj.getParent());
        if (!(store instanceof Store)) {
            return null;
        }
        Store objStore = store;
        Instruction instruction = objStore.getParent();
        if (!(instruction instanceof Block)) {
            return null;
        }
        Block handlerBlock = (Block)instruction;
        Store store2 = LoadStoreMatching.matchStoreLocal(objStore.getNextSiblingOrNull());
        if (!(store2 instanceof Store)) {
            return null;
        }
        Store toStringTarget = store2;
        Load load = LoadStoreMatching.matchLoadLocal(toStringTarget.getValue());
        if (!(load instanceof Load)) {
            return null;
        }
        Load exLoad = load;
        Store store3 = LoadStoreMatching.matchStoreLocal(toStringTarget.getNextSiblingOrNull());
        if (!(store3 instanceof Store)) {
            return null;
        }
        Store toStringResult = store3;
        Invoke invoke = InvokeMatching.matchInvoke(toStringResult.getValue(), Invoke.InvokeKind.VIRTUAL, "toString");
        if (!(invoke instanceof Invoke) || !(toStringCall = invoke).getArguments().isEmpty()) {
            return null;
        }
        Store store4 = LoadStoreMatching.matchStoreLocal(toStringResult.getNextSiblingOrNull());
        if (!(store4 instanceof Store)) {
            return null;
        }
        Store ctorP2 = store4;
        if (LoadStoreMatching.matchLoadLocal(ctorP2.getValue(), exLoad.getVariable()) == null) {
            return null;
        }
        Invoke invoke2 = InvokeMatching.matchConstructorInvokeSpecial(ctorP2.getNextSiblingOrNull(), this.c_MatchException);
        if (!(invoke2 instanceof Invoke) || (ctorCall = invoke2).getArguments().size() != 2) {
            return null;
        }
        if (LoadStoreMatching.matchLoadLocal(ctorCall.getTarget(), objStore.getVariable()) == null) {
            return null;
        }
        if (LoadStoreMatching.matchLoadLocal(ctorCall.getArguments().get(0), toStringResult.getVariable()) == null) {
            return null;
        }
        if (LoadStoreMatching.matchLoadLocal(ctorCall.getArguments().get(1), ctorP2.getVariable()) == null) {
            return null;
        }
        Store store5 = LoadStoreMatching.matchStoreLocal(ctorCall.getNextSiblingOrNull());
        if (!(store5 instanceof Store)) {
            return null;
        }
        Store throwStore = store5;
        if (LoadStoreMatching.matchLoadLocal(throwStore.getValue(), objStore.getVariable()) == null) {
            return null;
        }
        Instruction instruction2 = throwStore.getNextSiblingOrNull();
        if (!(instruction2 instanceof Throw)) {
            return null;
        }
        Throw thrw = (Throw)instruction2;
        if (LoadStoreMatching.matchLoadLocal(thrw.getArgument(), throwStore.getVariable()) == null) {
            return null;
        }
        return handlerBlock;
    }

    private void tryReplaceExactConversionWithInstanceOf(Block block, MethodTransformContext ctx) {
        Store store;
        Store deadVar;
        Instruction instruction = block.instructions.secondToLastOrDefault();
        if (!(instruction instanceof IfInstruction)) {
            return;
        }
        IfInstruction ifInsn = (IfInstruction)instruction;
        Instruction instruction2 = ifInsn.getCondition();
        if (!(instruction2 instanceof LogicNot)) {
            return;
        }
        LogicNot lN = (LogicNot)instruction2;
        LdcBoolean ldcBoolean = LdcMatching.matchLdcBoolean(LoadStoreMatching.matchPushForPop(lN.getArgument()), true);
        if (!(ldcBoolean instanceof LdcBoolean)) {
            return;
        }
        LdcBoolean ldcTrue = ldcBoolean;
        Instruction instruction3 = ifInsn.getPrevSibling().getPrevSiblingOrNull();
        if (!(instruction3 instanceof Store) || (deadVar = (Store)instruction3).getVariable().getLoadCount() != 0) {
            return;
        }
        Load load = LoadStoreMatching.matchLoadLocal(LoadStoreMatching.matchPushForPop(deadVar.getValue()));
        if (!(load instanceof Load)) {
            return;
        }
        Load sharedLoad = load;
        Instruction instruction4 = block.getNextSiblingOrNull();
        if (!(instruction4 instanceof Block)) {
            return;
        }
        Block next = (Block)instruction4;
        if (BranchLeaveMatching.matchBranch(block.getLastChild(), next) == null) {
            return;
        }
        Instruction instruction5 = next.getFirstChild();
        if (!(instruction5 instanceof Store) || LoadStoreMatching.matchLoadLocal((store = (Store)instruction5).getValue(), sharedLoad.getVariable()) == null) {
            return;
        }
        ctx.pushStep("Replace exact conversion with instanceof");
        AType type = deadVar.getResultType();
        ldcTrue.replaceWith(new InstanceOf(deadVar.getValue(), type));
        store.getValue().replaceWith(new Cast(store.getValue(), type));
        deadVar.remove();
        ctx.popStep();
    }
}

