/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.InstanceOf;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.RecordPattern;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.tags.RecordPatternComponentTag;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.util.Util;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;

public class RecordPatterns {
    /*
     * Loose catch block
     */
    public static boolean tryMakeRecordPattern(LocalReference existingPattern, MethodTransformContext ctx) {
        String name;
        ClassType type;
        AType aType = existingPattern.getType();
        if (!(aType instanceof ClassType) || !(type = (ClassType)aType).isRecord()) {
            return false;
        }
        List<Field> components = type.getRecordComponents();
        ArrayList<VariableCapturePattern> matchedPatterns = new ArrayList<VariableCapturePattern>();
        for (int i = 0; i < components.size(); ++i) {
            matchedPatterns.add(null);
        }
        LocalVariable storeVar = existingPattern.variable;
        for (LocalReference reference : storeVar.getReferences()) {
            Record record;
            if (reference == existingPattern) continue;
            Load load = LoadStoreMatching.matchLoadLocal(reference.getParent());
            if (!(load instanceof Load)) {
                return false;
            }
            Load refLoad = load;
            Invoke invoke = InvokeMatching.matchInvoke(refLoad.getParent(), Invoke.InvokeKind.VIRTUAL);
            if (!(invoke instanceof Invoke)) {
                return false;
            }
            Invoke retriever = invoke;
            if (!(retriever.getTag() instanceof RecordPatternComponentTag)) {
                return false;
            }
            name = retriever.getMethod().getName();
            int index = Util.indexOf(components, e -> e.getName().equals(name));
            if (index == -1) {
                return false;
            }
            assert (matchedPatterns.get(index) == null);
            Objects.requireNonNull(retriever.getParent());
            int n = 0;
            block13: while (true) {
                Instruction instruction;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Store.class, InstanceOf.class}, (Object)instruction, n)) {
                    case 0: {
                        Store usageStore = (Store)instruction;
                        if (!(usageStore.getReference() instanceof LocalReference)) {
                            n = 1;
                            continue block13;
                        }
                        record = new VariableCapturePattern(usageStore);
                        break block13;
                    }
                    case 1: {
                        InstanceOf patt = (InstanceOf)instruction;
                        if (patt.getPattern() instanceof Nop) {
                            n = 2;
                            continue block13;
                        }
                        record = new InvokeCapturePattern(retriever);
                        break block13;
                    }
                    default: {
                        record = null;
                        break block13;
                    }
                }
                break;
            }
            matchedPatterns.set(index, (VariableCapturePattern)record);
        }
        if (ColUtils.anyMatch(matchedPatterns, Objects::isNull)) {
            return false;
        }
        ctx.pushStep("Create record pattern");
        MethodDecl func = existingPattern.firstAncestorOfType(MethodDecl.class);
        RecordPattern pattern = new RecordPattern(type, (Iterable<Instruction>)FastStream.of(components).map(e -> new Nop()));
        existingPattern.replaceWith(pattern);
        block14: for (int i = 0; i < matchedPatterns.size(); ++i) {
            MatchedPattern matchedPattern;
            MatchedPattern o = (MatchedPattern)matchedPatterns.get(i);
            name = components.get(i).getName();
            Objects.requireNonNull(o);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VariableCapturePattern.class, InvokeCapturePattern.class}, (Object)matchedPattern, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Object object;
                    VariableCapturePattern variableCapturePattern = (VariableCapturePattern)matchedPattern;
                    Object usage = object = variableCapturePattern.store();
                    ctx.pushStep("Local " + ((Store)usage).getVariable().getName() + " for " + name);
                    pattern.args.get(i).replaceWith(((Store)usage).getReference());
                    ((Instruction)usage).remove();
                    ctx.popStep();
                    continue block14;
                }
                case 1: {
                    Invoke invoke;
                    Object object = (InvokeCapturePattern)matchedPattern;
                    Invoke invoke2 = invoke = ((InvokeCapturePattern)object).invoke();
                    ctx.pushStep("Temp local for nested pattern " + name);
                    LocalVariable variable = new LocalVariable(LocalVariable.VariableKind.TEMP_LOCAL, invoke2.getResultType(), storeVar.getName() + "$" + invoke2.getMethod().getName());
                    func.variables.add(variable);
                    invoke2.replaceWith(new Load(new LocalReference(variable)).withTag(invoke2.getTag()));
                    pattern.args.get(i).replaceWith(new LocalReference(variable));
                    ctx.popStep();
                }
            }
        }
        ctx.popStep();
        return true;
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private record VariableCapturePattern(Store store) implements MatchedPattern
    {
    }

    private record InvokeCapturePattern(Invoke invoke) implements MatchedPattern
    {
    }

    private static sealed interface MatchedPattern
    permits VariableCapturePattern, InvokeCapturePattern {
    }
}

