/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.matching;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.Leave;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Return;
import net.covers1624.coffeegrinder.bytecode.insns.Switch;
import net.covers1624.coffeegrinder.bytecode.insns.Throw;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import org.jetbrains.annotations.Nullable;

public class BranchLeaveMatching {
    @Nullable
    public static Return matchReturn(@Nullable Instruction insn, MethodDecl method) {
        if (!(insn instanceof Return)) {
            return null;
        }
        Return ret = (Return)insn;
        return ret.getMethod() == method ? ret : null;
    }

    @Nullable
    public static Leave matchLeave(@Nullable Instruction insn, BlockContainer container) {
        if (!(insn instanceof Leave)) {
            return null;
        }
        Leave leave = (Leave)insn;
        if (leave.getTargetContainer() != container) {
            return null;
        }
        return leave;
    }

    @Nullable
    public static Branch matchBranch(@Nullable Instruction insn, Block targetBlock) {
        if (!(insn instanceof Branch)) {
            return null;
        }
        Branch branch = (Branch)insn;
        if (branch.getTargetBlock() != targetBlock) {
            return null;
        }
        return branch;
    }

    public static boolean compatibleExitInstruction(@Nullable Instruction exit1, @Nullable Instruction exit2) {
        boolean bl;
        Instruction instruction = exit1;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Branch.class, Leave.class, Switch.SwitchGuard.class}, (Object)instruction, n)) {
                case 0: {
                    Branch br1 = (Branch)instruction;
                    if (!(exit2 instanceof Branch)) {
                        n = 1;
                        continue block5;
                    }
                    Branch br2 = (Branch)exit2;
                    if (br1.getTargetBlock() == br2.getTargetBlock()) {
                        bl = true;
                        break block5;
                    }
                    bl = false;
                    break block5;
                }
                case 1: {
                    Leave l1 = (Leave)instruction;
                    if (!(exit2 instanceof Leave)) {
                        n = 2;
                        continue block5;
                    }
                    Leave l2 = (Leave)exit2;
                    if (l1.getTargetContainer() == l2.getTargetContainer()) {
                        bl = true;
                        break block5;
                    }
                    bl = false;
                    break block5;
                }
                case 2: {
                    Switch.SwitchGuard sg1 = (Switch.SwitchGuard)instruction;
                    if (!(exit2 instanceof Switch.SwitchGuard)) {
                        n = 3;
                        continue block5;
                    }
                    Switch.SwitchGuard sg2 = (Switch.SwitchGuard)exit2;
                    if (sg1.swtch == sg2.swtch) {
                        bl = true;
                        break block5;
                    }
                    bl = false;
                    break block5;
                }
                default: {
                    bl = false;
                    break block5;
                }
            }
            break;
        }
        return bl;
    }

    @Nullable
    public static Throw matchThrow(@Nullable Instruction insn, LocalVariable variable) {
        if (!(insn instanceof Throw)) {
            return null;
        }
        Throw thr = (Throw)insn;
        if (LoadStoreMatching.matchLoadLocal(thr.getArgument(), variable) == null) {
            return null;
        }
        return thr;
    }

    @Nullable
    public static Instruction tryGetExit(@Nullable Instruction insn) {
        Instruction exitInsn = insn;
        if (insn instanceof Block) {
            exitInsn = insn.getLastChildOrNull();
        }
        if (exitInsn != null && exitInsn.hasFlag(InstructionFlag.END_POINT_UNREACHABLE)) {
            return exitInsn;
        }
        return null;
    }

    public static Instruction getExit(Instruction insn) {
        return Objects.requireNonNull(BranchLeaveMatching.tryGetExit(insn));
    }
}

