/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.LinkedList;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.flow.ControlFlowGraph;
import net.covers1624.coffeegrinder.bytecode.flow.ControlFlowNode;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.Cast;
import net.covers1624.coffeegrinder.bytecode.insns.FieldReference;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.InstanceOf;
import net.covers1624.coffeegrinder.bytecode.insns.Leave;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.LogicAnd;
import net.covers1624.coffeegrinder.bytecode.insns.LogicNot;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.Ternary;
import net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching;
import net.covers1624.coffeegrinder.bytecode.matching.IfMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.RecordPatterns;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.statement.ExpressionTransforms;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.statement.Inlining;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.JavaVersion;

public class ConditionDetection
implements BlockTransformer {
    private BlockTransformContext ctx;

    @Override
    public void transform(Block block, BlockTransformContext ctx) {
        this.ctx = ctx;
        Instruction instruction = block.instructions.secondToLastOrDefault();
        if (instruction instanceof IfInstruction) {
            IfInstruction ifInsn = (IfInstruction)instruction;
            this.handleIfInstruction(block, ifInsn);
        } else {
            ConditionDetection.inlineExitBranch(block, ctx);
        }
    }

    private void handleIfInstruction(Block block, IfInstruction ifInsn) {
        this.invertIf(ifInsn);
        while (this.inlineTrueBranch(ifInsn) || ConditionDetection.inlineExitBranch(block, this.ctx)) {
            boolean shortCircuit;
            do {
                boolean needsInvert = this.prepareShortCircuitOr(ifInsn) || this.prepareInvertedTernary(ifInsn);
                this.tryMergeTrueExitWithFallthrough(block, ifInsn);
                shortCircuit = this.introduceShortCircuit(ifInsn);
                this.produceTernary(ifInsn);
                if (!needsInvert) continue;
                this.invertIf(ifInsn);
            } while (shortCircuit);
        }
        this.mergeExitsForInline(block, ifInsn);
    }

    private static void canonicalize(IfInstruction ifInsn, MethodTransformContext ctx) {
        Block block;
        Instruction instruction = ifInsn.getTrueInsn();
        if (instruction instanceof Block) {
            block = (Block)instruction;
            ConditionDetection.tryUnwrap(block, ctx);
        }
        if ((instruction = ifInsn.getFalseInsn()) instanceof Block) {
            block = (Block)instruction;
            ConditionDetection.tryUnwrap(block, ctx);
        }
    }

    public static void tryUnwrap(Block block, MethodTransformContext ctx) {
        Instruction child;
        Instruction instruction = block.getFirstChildOrNull();
        if (!(instruction instanceof Instruction) || Block.requiresBlock(child = instruction)) {
            return;
        }
        ctx.pushStep("Unwrap block");
        assert (child.hasFlag(InstructionFlag.END_POINT_UNREACHABLE));
        block.replaceWith(child);
        ctx.popStep();
    }

    private boolean prepareInvertedTernary(IfInstruction ifInsn) {
        Instruction instruction = ifInsn.getTrueInsn();
        if (!(instruction instanceof Block)) {
            return false;
        }
        Block ternaryThenCond = (Block)instruction;
        IfInstruction thenIf = Inlining.matchWithPotentialInline(ternaryThenCond.getFirstChildOrNull(), new LinkedList<Runnable>(), this.ctx, IfMatching::matchNopFalseIf);
        if (thenIf == null) {
            return false;
        }
        IfInstruction elseIf = Inlining.matchWithPotentialInline(ifInsn.getNextSiblingOrNull(), new LinkedList<Runnable>(), this.ctx, IfMatching::matchNopFalseIf);
        if (elseIf == null) {
            return false;
        }
        if (!BranchLeaveMatching.compatibleExitInstruction(thenIf.getTrueInsn(), elseIf.getNextSiblingOrNull())) {
            return false;
        }
        if (!BranchLeaveMatching.compatibleExitInstruction(thenIf.getNextSiblingOrNull(), elseIf.getTrueInsn())) {
            return false;
        }
        this.ctx.pushStep("Prepare inverted ternary");
        this.invertIf(elseIf);
        this.ctx.popStep();
        return true;
    }

    private boolean inlineTrueBranch(IfInstruction ifInsn) {
        int nextInsnBytecodeOffset;
        if (!ConditionDetection.canInline(ifInsn.getTrueInsn())) {
            return false;
        }
        assert (IfMatching.matchNopFalseIf(ifInsn) != null);
        Block targetBlock = ((Branch)ifInsn.getTrueInsn()).getTargetBlock();
        Instruction fallthrough = ifInsn.getNextSibling();
        int n = nextInsnBytecodeOffset = !(fallthrough instanceof Branch) && !(fallthrough instanceof Leave) ? fallthrough.getBytecodeOffset() : -1;
        if (nextInsnBytecodeOffset >= 0 && nextInsnBytecodeOffset < targetBlock.getBytecodeOffset()) {
            return false;
        }
        this.ctx.pushStep("Inline true-branch");
        ifInsn.setTrueInsn(targetBlock);
        this.tryProduceInstanceofPattern(ifInsn);
        ConditionDetection.canonicalize(ifInsn, this.ctx);
        this.ctx.popStep();
        return true;
    }

    private void tryProduceInstanceofPattern(IfInstruction ifInsn) {
        if (!this.ctx.classVersion.isAtLeast(JavaVersion.JAVA_17)) {
            return;
        }
        Instruction instruction = ifInsn.getTrueInsn();
        if (!(instruction instanceof Block)) {
            return;
        }
        Block trueBlock = (Block)instruction;
        Store store = LoadStoreMatching.matchStoreLocal(trueBlock.getFirstChildOrNull());
        if (!(store instanceof Store)) {
            return;
        }
        Store store2 = store;
        LocalVariable variable = store2.getVariable();
        if (variable.getKind() != LocalVariable.VariableKind.LOCAL) {
            return;
        }
        Instruction condPushFrom = LoadStoreMatching.matchPushForPop(ifInsn.getCondition());
        if (condPushFrom == null || condPushFrom.getParent() != ifInsn.getPrevSiblingOrNull()) {
            return;
        }
        if (!(condPushFrom instanceof InstanceOf)) {
            return;
        }
        InstanceOf instanceOf = (InstanceOf)condPushFrom;
        Instruction arg = store2.getValue();
        if (arg instanceof Cast) {
            Cast cast = (Cast)arg;
            if (!cast.getType().equals(instanceOf.getType())) {
                return;
            }
            arg = cast.getArgument();
        } else if (!this.ctx.classVersion.isAtLeast(JavaVersion.JAVA_21)) {
            return;
        }
        Load load = LoadStoreMatching.matchLoadLocal(arg);
        if (!(load instanceof Load)) {
            return;
        }
        Load load2 = load;
        if (LoadStoreMatching.matchLoadLocal(LoadStoreMatching.matchPushForPop(instanceOf.getArgument()), load2.getVariable()) == null) {
            return;
        }
        ControlFlowGraph cfg = this.ctx.getControlFlowGraph();
        ControlFlowNode head = cfg.getNode(trueBlock);
        if (!ColUtils.allMatch(variable.getReferences(), i -> !i.isWrittenTo() || cfg.dominates(head, (Instruction)i))) {
            return;
        }
        this.ctx.pushStep("Create pattern matched instanceof");
        instanceOf.setPattern((LocalReference)store2.getReference());
        store2.remove();
        RecordPatterns.tryMakeRecordPattern((LocalReference)instanceOf.getPattern(), this.ctx);
        Instruction instruction2 = trueBlock.getFirstChild();
        if (instruction2 instanceof Branch) {
            Branch br = (Branch)instruction2;
            if (br.getTargetBlock() != ifInsn.getParent().getNextSiblingOrNull()) {
                this.invertIf(ifInsn);
            }
        } else if (trueBlock.getFirstChild() instanceof Leave) {
            this.invertIf(ifInsn);
        }
        this.ctx.popStep();
    }

    public static boolean inlineExitBranch(Block block, BlockTransformContext ctx) {
        Instruction exitInsn = BranchLeaveMatching.getExit(block);
        if (!ConditionDetection.canInline(exitInsn)) {
            return false;
        }
        ctx.pushStep("Inline exit-branch");
        Block targetBlock = ((Branch)exitInsn).getTargetBlock();
        ((Instruction)block.instructions.last()).remove();
        block.instructions.addAll((Iterable<Instruction>)((Object)targetBlock.instructions));
        targetBlock.remove();
        ctx.popStep();
        return true;
    }

    private static boolean canInline(Instruction exitInsn) {
        if (!(exitInsn instanceof Branch)) {
            return false;
        }
        Branch branch = (Branch)exitInsn;
        Block targetBlock = branch.getTargetBlock();
        if (targetBlock.getIncomingEdgeCount() != 1) {
            return false;
        }
        Block parentBlock = (Block)exitInsn.ancestorsOfType(Block.class).filter(b -> b.getParent() instanceof BlockContainer).first();
        return parentBlock.getNextSiblingOrNull() == targetBlock;
    }

    private void mergeExitsForInline(Block block, IfInstruction ifInsn) {
        if (IfMatching.matchNopFalseIf(ifInsn) == null) {
            return;
        }
        Block nextBlock = (Block)block.getNextSiblingOrNull();
        if (nextBlock == null) {
            return;
        }
        if (!nextBlock.getBranches().allMatch(b -> b.isDescendantOf(block))) {
            return;
        }
        this.moveBranchExitsTowardsRoot(block, nextBlock);
        ConditionDetection.inlineExitBranch(block, this.ctx);
    }

    private void moveBranchExitsTowardsRoot(Block block, Block targetBlock) {
        if (!block.hasFlag(InstructionFlag.END_POINT_UNREACHABLE)) {
            return;
        }
        for (Instruction insn = block.getLastChild(); insn != null; insn = insn.getPrevSiblingOrNull()) {
            Branch trueExit;
            IfInstruction ifInsn = IfMatching.matchNopFalseIf(insn);
            if (ifInsn == null) continue;
            Instruction instruction = ifInsn.getTrueInsn();
            if (instruction instanceof Block) {
                Block trueBlock = (Block)instruction;
                this.moveBranchExitsTowardsRoot(trueBlock, targetBlock);
            }
            if ((trueExit = BranchLeaveMatching.matchBranch(BranchLeaveMatching.tryGetExit(ifInsn.getTrueInsn()), targetBlock)) == null) continue;
            if (BranchLeaveMatching.compatibleExitInstruction(BranchLeaveMatching.tryGetExit(block), trueExit)) {
                this.mergeTrueExitWithFallthrough(block, ifInsn);
                continue;
            }
            this.moveTrueExitToFallthrough(block, ifInsn);
        }
    }

    private void moveTrueExitToFallthrough(Block block, IfInstruction ifInsn) {
        this.ctx.pushStep("Move true exit to fallthrough");
        this.ctx.pushStep("Introduce else");
        ifInsn.setFalseInsn(block.extractRange(ifInsn.getNextSibling(), block.getLastChild()));
        ConditionDetection.canonicalize(ifInsn, this.ctx);
        this.ctx.popStep();
        Instruction exit = BranchLeaveMatching.getExit(ifInsn.getTrueInsn());
        ConditionDetection.ensureParentIsBlock(exit);
        block.instructions.add(exit);
        this.ctx.popStep();
    }

    private void tryMergeTrueExitWithFallthrough(Block block, IfInstruction ifInsn) {
        Instruction exit;
        if (IfMatching.matchNopFalseIf(ifInsn) == null) {
            return;
        }
        Instruction trueExit = BranchLeaveMatching.tryGetExit(ifInsn.getTrueInsn());
        if (BranchLeaveMatching.compatibleExitInstruction(trueExit, exit = BranchLeaveMatching.tryGetExit(block))) {
            this.mergeTrueExitWithFallthrough(block, ifInsn);
        }
    }

    private void mergeTrueExitWithFallthrough(Block block, IfInstruction ifInsn) {
        this.ctx.pushStep("Merge true exit with fallthrough");
        if (ifInsn != block.instructions.secondToLastOrDefault()) {
            assert (ifInsn.getFalseInsn() instanceof Nop);
            this.ctx.pushStep("Introduce else");
            ifInsn.setFalseInsn(block.extractRange(ifInsn.getNextSibling(), block.getLastChild().getPrevSibling()));
            ConditionDetection.canonicalize(ifInsn, this.ctx);
            this.ctx.popStep();
        }
        Instruction exit = BranchLeaveMatching.getExit(ifInsn.getTrueInsn());
        ConditionDetection.ensureParentIsBlock(exit);
        exit.remove();
        this.ctx.popStep();
    }

    private boolean prepareShortCircuitOr(IfInstruction ifInsn) {
        Block trueBlock;
        Instruction instruction = ifInsn.getNextSibling();
        if (!(instruction instanceof Branch)) {
            return false;
        }
        Branch elseBranch = (Branch)instruction;
        Instruction instruction2 = ifInsn.getTrueInsn();
        if (!(instruction2 instanceof Block) || BranchLeaveMatching.tryGetExit(trueBlock = (Block)instruction2) == null) {
            return false;
        }
        IfInstruction trueIf = Inlining.matchWithPotentialInline(trueBlock.getFirstChildOrNull(), new LinkedList<Runnable>(), this.ctx, IfMatching::matchNopFalseIf);
        if (trueIf == null || BranchLeaveMatching.matchBranch(trueIf.getTrueInsn(), elseBranch.getTargetBlock()) == null) {
            return false;
        }
        this.ctx.pushStep("Prepare short-circuit or");
        this.invertIf(trueIf);
        this.ctx.popStep();
        return true;
    }

    private boolean introduceShortCircuit(IfInstruction ifInsn) {
        if (IfMatching.matchNopFalseIf(ifInsn) == null) {
            return false;
        }
        Instruction instruction = ifInsn.getTrueInsn();
        if (!(instruction instanceof Block)) {
            return false;
        }
        Block trueBlock = (Block)instruction;
        LinkedList<Runnable> extraTransforms = new LinkedList<Runnable>();
        IfInstruction nestedIf = Inlining.matchWithPotentialInline(trueBlock.getFirstChildOrNull(), extraTransforms, this.ctx, IfMatching::matchNopFalseIf);
        if (nestedIf == null) {
            return false;
        }
        if (nestedIf.getNextSiblingOrNull() != null) {
            return false;
        }
        if (this.isAssertion(nestedIf)) {
            return false;
        }
        this.ctx.pushStep("Introduce short-circuit");
        extraTransforms.forEach(Runnable::run);
        ifInsn.setCondition(new LogicAnd(ifInsn.getCondition(), nestedIf.getCondition()));
        ifInsn.setTrueInsn(nestedIf.getTrueInsn());
        ExpressionTransforms.runOnExpression(ifInsn.getCondition(), this.ctx);
        ConditionDetection.canonicalize(ifInsn, this.ctx);
        this.ctx.popStep();
        return true;
    }

    private boolean isAssertion(IfInstruction ifInsn) {
        Instruction instruction = ifInsn.getCondition();
        if (!(instruction instanceof LogicAnd)) {
            return false;
        }
        LogicAnd and = (LogicAnd)instruction;
        Instruction instruction2 = and.getLeft();
        if (!(instruction2 instanceof LogicNot)) {
            return false;
        }
        LogicNot not = (LogicNot)instruction2;
        Load load = LoadStoreMatching.matchLoadField(not.getArgument());
        if (load == null) {
            return false;
        }
        Field field = ((FieldReference)load.getReference()).getField();
        return field.isSynthetic() && field.getName().equals("$assertionsDisabled");
    }

    private void produceTernary(IfInstruction ifInsn) {
        Instruction instruction = ifInsn.getTrueInsn();
        if (!(instruction instanceof Block)) {
            return;
        }
        Block trueBlock = (Block)instruction;
        LinkedList<Runnable> extraTransforms = new LinkedList<Runnable>();
        IfInstruction thenIf = Inlining.matchWithPotentialInline(trueBlock.getFirstChildOrNull(), extraTransforms, this.ctx, IfMatching::matchNopFalseIf);
        if (thenIf == null || thenIf.getNextSiblingOrNull() != null) {
            return;
        }
        Instruction instruction2 = ifInsn.getFalseInsn();
        if (!(instruction2 instanceof Block)) {
            return;
        }
        Block falseBlock = (Block)instruction2;
        IfInstruction elseIf = Inlining.matchWithPotentialInline(falseBlock.getFirstChildOrNull(), extraTransforms, this.ctx, IfMatching::matchNopFalseIf);
        if (elseIf == null || elseIf.getNextSiblingOrNull() != null) {
            return;
        }
        if (!BranchLeaveMatching.compatibleExitInstruction(thenIf.getTrueInsn(), elseIf.getTrueInsn())) {
            return;
        }
        this.ctx.pushStep("Produce ternary");
        extraTransforms.forEach(Runnable::run);
        ifInsn.setCondition(new Ternary(ifInsn.getCondition(), thenIf.getCondition(), elseIf.getCondition()));
        ifInsn.setTrueInsn((Instruction)FastStream.of((Object[])new Instruction[]{thenIf.getTrueInsn(), elseIf.getTrueInsn()}).maxBy(Instruction::getBytecodeOffset));
        ifInsn.setFalseInsn(new Nop());
        this.ctx.popStep();
    }

    private void invertIf(IfInstruction ifInsn) {
        ConditionDetection.invertIf(ifInsn, this.ctx);
    }

    public static void invertIf(IfInstruction ifInsn, MethodTransformContext ctx) {
        Instruction thenInsn;
        Block block = (Block)ifInsn.getParent();
        ctx.pushStep("Invert if");
        assert (ifInsn.getParentOrNull() == block);
        assert (ifInsn.getFalseInsn() instanceof Nop);
        BranchLeaveMatching.getExit(ifInsn.getTrueInsn());
        Instruction elseInsn = BranchLeaveMatching.getExit(block);
        if (ifInsn.getNextSibling() != elseInsn) {
            elseInsn = block.extractRange(ifInsn.getNextSibling(), elseInsn);
        }
        if ((thenInsn = ifInsn.getTrueInsn()) instanceof Block) {
            Block thenBlock = (Block)thenInsn;
            block.instructions.addAll((Iterable<Instruction>)((Object)thenBlock.instructions));
        } else {
            block.instructions.add(thenInsn);
        }
        ifInsn.setTrueInsn(elseInsn);
        ifInsn.setCondition(new LogicNot(ifInsn.getCondition()));
        ExpressionTransforms.runOnExpression(ifInsn.getCondition(), ctx);
        ConditionDetection.canonicalize(ifInsn, ctx);
        ctx.popStep();
    }

    private static void ensureParentIsBlock(Instruction insn) {
        if (insn.getParent() instanceof Block) {
            return;
        }
        Block b = new Block();
        b.instructions.add(insn);
        insn.replaceWith(b);
    }
}

