/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.Cast;
import net.covers1624.coffeegrinder.bytecode.insns.FieldReference;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.InstanceOf;
import net.covers1624.coffeegrinder.bytecode.insns.InvokeDynamic;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNull;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNumber;
import net.covers1624.coffeegrinder.bytecode.insns.LdcString;
import net.covers1624.coffeegrinder.bytecode.insns.Leave;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.LogicNot;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.Switch;
import net.covers1624.coffeegrinder.bytecode.insns.SwitchTable;
import net.covers1624.coffeegrinder.bytecode.insns.WhileLoop;
import net.covers1624.coffeegrinder.bytecode.insns.tags.RecordPatternComponentTag;
import net.covers1624.coffeegrinder.bytecode.insns.tags.SwitchRecordPatternTag;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LdcMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class PrepareSwitchOnType
implements MethodTransformer {
    private final ClassType string;
    @Nullable
    private final ClassType c_switchBootstraps;

    public PrepareSwitchOnType(TypeResolver resolver) {
        this.string = resolver.resolveClass(String.class);
        this.c_switchBootstraps = resolver.tryResolveClassDecl("java/lang/runtime/SwitchBootstraps");
    }

    @Override
    public void transform(MethodDecl function, MethodTransformContext ctx) {
        if (this.c_switchBootstraps == null) {
            return;
        }
        function.descendantsToList(Switch.class).forEach(e -> this.processSwitch(function, (Switch)e, ctx));
    }

    private void processSwitch(MethodDecl function, Switch swtch, MethodTransformContext ctx) {
        assert (this.c_switchBootstraps != null);
        InvokeDynamic indy = PrepareSwitchOnType.matchTypeSwitchIndy(LoadStoreMatching.matchPushForPop(swtch.getValue()), this.c_switchBootstraps);
        if (indy == null) {
            return;
        }
        ctx.pushStep("Process switch " + swtch.getBody().getEntryPoint().getName());
        boolean isExpression = swtch.getParent() instanceof Store;
        assert (isExpression && indy.getParent() == swtch.getParent().getPrevSibling() || indy.getParent() == swtch.getPrevSiblingOrNull());
        Store indyPush = (Store)indy.getParent();
        Load idxLoad = Objects.requireNonNull(LoadStoreMatching.matchLoadLocal(LoadStoreMatching.matchPushForPop(indyPush.getPrevSibling(), indy.arguments.get(1))));
        Store idxPush = (Store)idxLoad.getParent();
        LocalVariable idxVar = idxLoad.getVariable();
        Load selLoad = Objects.requireNonNull(LoadStoreMatching.matchLoadLocal(LoadStoreMatching.matchPushForPop(idxPush.getPrevSibling(), indy.arguments.get(0))));
        Store selPush = (Store)selLoad.getParent();
        LocalVariable selVar = selLoad.getVariable();
        WhileLoop outerLoop = this.matchOuterLoop(swtch, selPush);
        if (outerLoop != null) {
            this.tryUnwrapGuardLoop(outerLoop, swtch, isExpression, idxVar, ctx);
        }
        this.processSwitchCases(function, swtch, indy, selVar, ctx);
        ctx.popStep();
    }

    @Nullable
    private WhileLoop matchOuterLoop(Switch swtch, Store selPush) {
        if (selPush.getPrevSiblingOrNull() != null) {
            return null;
        }
        if (swtch.getNextSiblingOrNull() != null) {
            return null;
        }
        WhileLoop loop = (WhileLoop)selPush.getParent().getParent().getParent();
        assert (loop.getBody().blocks.size() == 1);
        assert (loop.getPrevSiblingOrNull() == null);
        assert (loop.getNextSiblingOrNull() instanceof Branch);
        assert (LdcMatching.matchLdcBoolean(loop.getCondition(), true) != null);
        return loop;
    }

    private void tryUnwrapGuardLoop(WhileLoop outerLoop, Switch swtch, boolean isExpression, LocalVariable idxVar, MethodTransformContext ctx) {
        Block entry = outerLoop.getBody().getEntryPoint();
        ctx.pushStep("Unwrap switch on type guard loop");
        for (Branch branch : outerLoop.getBody().getEntryPoint().getBranches().toList()) {
            Block block = (Block)branch.getParent();
            Store idxStore = Objects.requireNonNull(LoadStoreMatching.matchStoreLocal(branch.getPrevSibling(), idxVar));
            LdcNumber idxTmp = Objects.requireNonNull(LdcMatching.matchLdcInt(LoadStoreMatching.matchPushForPop(idxStore.getPrevSibling(), idxStore.getValue())));
            assert (idxTmp.getParent().getPrevSiblingOrNull() == null);
            block.getBranches().toList().forEach(e -> e.replaceWith(new Switch.SwitchGuard(swtch)));
            block.remove();
        }
        if (isExpression) {
            Leave leave2 = (Leave)outerLoop.getBody().getLeaves().only();
            assert (swtch.getParent().getNextSibling() == leave2);
            leave2.remove();
        } else {
            outerLoop.getBody().getLeaves().toList().forEach(leave -> leave.replaceWith(new Leave(swtch.getBody()).withOffsets((Instruction)leave)));
        }
        Block loopBlock = (Block)outerLoop.getParent();
        loopBlock.instructions.addAllFirst((Iterable<Instruction>)((Object)entry.instructions));
        outerLoop.remove();
        ctx.popStep();
    }

    private void processSwitchCases(MethodDecl function, Switch swtch, InvokeDynamic indy, LocalVariable selVar, MethodTransformContext ctx) {
        Object[] indyArgs = indy.bootstrapArguments;
        if (indy.bootstrapHandle.getName().equals("enumSwitch")) {
            indyArgs = PrepareSwitchOnType.resolveEnumSwitchArgs((ClassType)indy.descriptorArgs[0], indyArgs);
        }
        ctx.pushStep("Process switch cases");
        Iterator<SwitchTable.SwitchSection> iterator = swtch.getSwitchTable().sections.iterator();
        while (iterator.hasNext()) {
            SwitchTable.SwitchSection section = iterator.next();
            Iterator<Instruction> iterator2 = section.values.iterator();
            while (iterator2.hasNext()) {
                Instruction value = iterator2.next();
                if (value instanceof Nop) {
                    ctx.pushStep("Try capture unconditional default pattern");
                    this.tryCapturePatternVariable(function, swtch, selVar, value, section, null, ctx);
                    ctx.popStep();
                    continue;
                }
                int idx = ((LdcNumber)value).getValue().intValue();
                ctx.pushStep("Rewrite case " + idx);
                this.rewriteSwitchCase(function, swtch, selVar, section, indyArgs, idx, value, ctx);
                ctx.popStep();
            }
        }
        ctx.popStep();
    }

    private boolean tryCapturePatternVariable(MethodDecl function, Switch swtch, LocalVariable selVar, Instruction value, SwitchTable.SwitchSection section, @Nullable ClassType indyArg, MethodTransformContext ctx) {
        LocalVariable patternVar;
        Store store;
        Instruction instruction = section.getBody();
        if (!(instruction instanceof Branch)) {
            return false;
        }
        Branch switchBranch = (Branch)instruction;
        Block sectionBody = switchBranch.getTargetBlock();
        Store store2 = LoadStoreMatching.matchPush(sectionBody.getFirstChild());
        if (!(store2 instanceof Store)) {
            return false;
        }
        Store push1 = store2;
        Load load = LoadStoreMatching.matchLoadLocal(push1.getValue(), selVar);
        if (!(load instanceof Load)) {
            return false;
        }
        Load selVarLoad = load;
        Store varStoreSource = push1;
        Cast cast = LoadStoreMatching.matchStoreCast(varStoreSource.getNextSiblingOrNull(), indyArg);
        if (cast != null) {
            varStoreSource = (Store)cast.getParent();
        }
        if (!((store = LoadStoreMatching.matchStoreLocalLoadLocal(varStoreSource.getNextSiblingOrNull(), varStoreSource.getVariable())) instanceof Store)) {
            return false;
        }
        Store varStore = store;
        if (cast != null && (patternVar = this.insertSyntheticRecordPatternInstanceofRoot(function, swtch, sectionBody, switchBranch, selVarLoad, cast, varStore, ctx)) != null) {
            value.replaceWith(new SwitchTable.SwitchPattern(new LocalReference(patternVar)));
            return true;
        }
        ctx.pushStep("Capture variable into switch section.");
        value.replaceWith(new SwitchTable.SwitchPattern((LocalReference)varStore.getReference()));
        push1.remove();
        if (varStoreSource != push1) {
            varStoreSource.remove();
        }
        varStore.remove();
        ctx.popStep();
        return true;
    }

    @Nullable
    private LocalVariable insertSyntheticRecordPatternInstanceofRoot(MethodDecl function, Switch swtch, Block sectionBody, Branch switchBranch, Load selVarLoad, Cast cast, Store varStore, MethodTransformContext ctx) {
        ClassType recordType;
        AType castedType = cast.getType();
        LocalVariable synVar = varStore.getVariable();
        if (!(castedType instanceof ClassType) || !(recordType = (ClassType)castedType).isRecord()) {
            return null;
        }
        if (synVar.getStoreCount() != 1) {
            return null;
        }
        if (!ColUtils.anyMatch(synVar.getReferences(), this::isRecordPatternUsage)) {
            return null;
        }
        ctx.pushStep("Produce synthetic instanceof for record pattern case");
        Block synBlock = new Block(sectionBody.getSubName("syn_record_pattern_instanceof"));
        sectionBody.insertBefore(synBlock);
        LocalVariable varTemp = new LocalVariable(LocalVariable.VariableKind.STACK_SLOT, selVarLoad.getVariable().getType(), "s_" + function.variables.size());
        function.variables.add(varTemp);
        LocalVariable boolStack = new LocalVariable(LocalVariable.VariableKind.STACK_SLOT, PrimitiveType.BOOLEAN, "s_" + function.variables.size());
        function.variables.add(boolStack);
        LocalVariable tempVar = new LocalVariable(LocalVariable.VariableKind.TEMP_LOCAL, castedType, "case$" + function.variables.size());
        function.variables.add(tempVar);
        tempVar.setTag(new SwitchRecordPatternTag());
        InstanceOf instanceOf = new InstanceOf(new Load(new LocalReference(varTemp)), castedType);
        synBlock.instructions.add(new Store(new LocalReference(varTemp), new Load(new LocalReference(tempVar))));
        synBlock.instructions.add(new Store(new LocalReference(boolStack), instanceOf));
        synBlock.instructions.add(new IfInstruction(new LogicNot(new Load(new LocalReference(boolStack))), new Switch.SwitchGuard(swtch)));
        synBlock.instructions.add(new Branch(sectionBody));
        switchBranch.replaceWith(new Branch(synBlock));
        selVarLoad.getReference().replaceWith(new LocalReference(tempVar));
        ctx.popStep();
        return tempVar;
    }

    private boolean isRecordPatternUsage(LocalReference ref) {
        Load load = LoadStoreMatching.matchLoadLocal(ref.getParent());
        if (!(load instanceof Load)) {
            return false;
        }
        Load load2 = load;
        Store store = LoadStoreMatching.matchPush(load2.getParent());
        if (!(store instanceof Store)) {
            return false;
        }
        Store push = store;
        Load pop = (Load)FastStream.of(push.getVariable().getReferences()).map(e -> LoadStoreMatching.matchPop(e.getParent())).filter(Objects::nonNull).onlyOrDefault();
        if (pop == null) {
            return false;
        }
        return pop.getParent().getTag() instanceof RecordPatternComponentTag;
    }

    private void rewriteSwitchCase(MethodDecl function, Switch swtch, LocalVariable selVar, SwitchTable.SwitchSection section, Object[] indyArgs, int idx, Instruction value, MethodTransformContext ctx) {
        if (idx == -1) {
            value.replaceWith(new LdcNull());
            return;
        }
        Object object = indyArgs[idx];
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Integer.class, Type.class, Field.class}, (Object)object, n)) {
            case 0: {
                String s = (String)object;
                value.replaceWith(new LdcString(this.string, s));
                break;
            }
            case 1: {
                Integer i = (Integer)object;
                value.replaceWith(new LdcNumber(i));
                break;
            }
            case 2: {
                Type type = (Type)object;
                assert (section.values.size() == 1);
                ClassType cType = ctx.getTypeResolver().resolveClass(type);
                if (this.tryCapturePatternVariable(function, swtch, selVar, value, section, cType, ctx)) break;
                throw new IllegalStateException("Did not match a pattern variable for a type switch.");
            }
            case 3: {
                Field enumConstant = (Field)object;
                value.replaceWith(new FieldReference(enumConstant));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unhandled type switch type: " + String.valueOf(indyArgs[idx]));
            }
        }
    }

    @Nullable
    public static InvokeDynamic matchTypeSwitchIndy(@Nullable Instruction insn, ClassType switchBootstraps) {
        InvokeDynamic indy = InvokeMatching.matchInvokeDynamic(insn, switchBootstraps, "typeSwitch");
        if (indy == null) {
            indy = InvokeMatching.matchInvokeDynamic(insn, switchBootstraps, "enumSwitch");
        }
        if (indy == null) {
            return null;
        }
        if (indy.arguments.size() != 2) {
            return null;
        }
        return indy;
    }

    private static Object[] resolveEnumSwitchArgs(ClassType indyEnumType, Object[] args) {
        args = (Object[])args.clone();
        for (int i = 0; i < args.length; ++i) {
            Object object;
            Object arg = args[i];
            Objects.requireNonNull(arg);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Type.class}, (Object)object, n)) {
                case 0: {
                    String enumName = (String)object;
                    arg = FastStream.of(indyEnumType.getFields()).filter(e -> e.getAccessFlags().get(AccessFlag.ENUM) && e.getName().equals(enumName)).only();
                    break;
                }
                case 1: {
                    Type ignored = (Type)object;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected type in SwitchBootstraps.enumSwitch indy arguments. " + String.valueOf(arg));
                }
            }
            args[i] = arg;
        }
        return args;
    }
}

