package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;

/**
 * Created by covers1624 on 12/9/22.
 */
public final class LdcChar extends LdcInsn {

    private final char value;

    public LdcChar(char value) {
        this.value = value;
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.CHAR;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitLdcChar(this, ctx);
    }

    @Override
    public LdcChar copy() {
        return new LdcChar(value);
    }

    @Override
    public Character getRawValue() {
        return value;
    }

    public char getValue() {
        return value;
    }
}
