package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.IndexedInstructionCollection;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 11/26/25.
 */
public final class RecordPattern extends Instruction {

    public final ClassType type;
    public final IndexedInstructionCollection<Instruction> args = new IndexedInstructionCollection<>(this);

    public RecordPattern(ClassType type, Iterable<Instruction> args) {
        this.type = type;
        assert type.isRecord();
        this.args.setValues(args);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitRecordPattern(this, ctx);
    }

    @Override
    protected void onChildModified() {
        super.onChildModified();
        if (!isConnected()) return;

        for (Instruction arg : args) {
            if (arg instanceof LocalReference ref) {
                ref.setWrittenTo(true);
            }
        }
    }

    @Override
    protected void onConnected() {
        super.onConnected();

        for (Instruction arg : args) {
            if (arg instanceof LocalReference ref) {
                ref.setWrittenTo(true);
            }
        }
    }
}
