package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Leave;
import org.jetbrains.annotations.Nullable;

/**
 * Created by covers1624 on 2/10/21.
 */
public class TransformerUtils {

    public static void moveBlocksIntoContainer(Iterable<Block> blocks, @Nullable BlockContainer fromContainer, BlockContainer toContainer, @Nullable Block exitBlock) {
        for (Block block : blocks) {
            BlockContainer parent = (BlockContainer) block.getParentOrNull();
            if (parent != null && parent != fromContainer) {
                // some blocks might already be in use by nested containers that were detected earlier;
                // don't move those (they'll be implicitly moved when the block containing the nested container is moved).
                assert fromContainer != null;
                assert parent.isDescendantOf(fromContainer);
                continue;
            }

            Block target = toContainer.blocks.filter(e -> e.getBytecodeOffset() < block.getBytecodeOffset()).lastOrDefault();
            if (target != null) { // Try to put the block in order.
                target.insertAfter(block);
            } else {
                toContainer.blocks.add(block);
            }
        }

        if (exitBlock == null) return;

        exitBlock.getBranches()
                .filter(e -> e.isDescendantOf(toContainer))
                .toLinkedList()
                .forEach(e -> e.replaceWith(new Leave(toContainer).withOffsets(e)));
    }
}
