package net.covers1624.coffeegrinder.util.asm;

import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

/**
 * Created by covers1624 on 13/10/21.
 */
public class AsmUtils {

    public static int getFirstLocalIndex(MethodNode mNode) {
        Type[] argTypes = Type.getArgumentTypes(mNode.desc);
        int i = (mNode.access & Opcodes.ACC_STATIC) != 0 ? 0 : 1; // Offset by one for non-static methods, because 'this'.
        for (Type type : argTypes) {
            i++;
            if (type.getSort() == Type.LONG || type.getSort() == Type.DOUBLE) {
                i++;
            }
        }
        return i;
    }
}
