/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import java.util.BitSet;
import java.util.Iterator;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionCollection;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.Reference;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import org.jetbrains.annotations.Nullable;

public final class SwitchTable
extends Instruction {
    private final InstructionSlot<Instruction> value = new InstructionSlot(this);
    public final InstructionCollection<SwitchSection> sections = new InstructionCollection(this);
    @Nullable
    public final TableInfo tableInfo;

    public SwitchTable(Instruction value, @Nullable TableInfo tableInfo) {
        this.value.set(value);
        this.tableInfo = tableInfo;
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    protected EnumBitSet<InstructionFlag> computeFlags() {
        Object flags = this.getDirectFlags().copy();
        Iterator<SwitchSection> iterator = this.sections.iterator();
        while (iterator.hasNext()) {
            SwitchSection section = iterator.next();
            ((BitSet)flags).or(section.getFlags());
        }
        ((BitSet)flags).or(this.value.get().getFlags());
        return flags;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitSwitchTable(this, ctx);
    }

    public Instruction getValue() {
        return this.value.get();
    }

    public void setValue(Instruction value) {
        this.value.set(value);
    }

    public boolean isExhaustive() {
        return this.sections.anyMatch(section -> section.values.anyMatch(e -> e instanceof Nop));
    }

    public record TableInfo(int min, int max) {
    }

    public static final class SwitchSection
    extends Instruction {
        public final InstructionCollection<Instruction> values = new InstructionCollection(this);
        private final InstructionSlot<Instruction> body = new InstructionSlot(this);
        public boolean explicitBlock;

        public SwitchSection(Instruction body) {
            this.body.set(body);
        }

        @Override
        public AType getResultType() {
            return PrimitiveType.VOID;
        }

        @Override
        public EnumBitSet<InstructionFlag> getDirectFlags() {
            return InstructionFlag.NONE;
        }

        @Override
        public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
            return visitor.visitSwitchSection(this, ctx);
        }

        public Instruction getBody() {
            return this.body.get();
        }

        public void setBody(Instruction body) {
            this.body.set(body);
        }
    }

    public static class SwitchPattern
    extends Instruction {
        private final InstructionSlot<Instruction> pattern = new InstructionSlot(this);
        private final InstructionSlot<Instruction> condition = new InstructionSlot(this);

        public SwitchPattern(LocalReference pattern) {
            this(pattern, new Nop());
        }

        public SwitchPattern(LocalReference pattern, Instruction condition) {
            this.pattern.set(pattern);
            this.condition.set(condition);
        }

        @Override
        public AType getResultType() {
            return PrimitiveType.VOID;
        }

        @Override
        public EnumBitSet<InstructionFlag> getDirectFlags() {
            return InstructionFlag.NONE;
        }

        @Override
        public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
            return visitor.visitSwitchPattern(this, ctx);
        }

        @Override
        protected void onChildModified() {
            Instruction instruction;
            super.onChildModified();
            if (this.isConnected() && (instruction = this.getPattern()) instanceof Reference) {
                Reference ref = (Reference)instruction;
                ref.setWrittenTo(true);
            }
        }

        @Override
        protected void onConnected() {
            super.onConnected();
            Instruction instruction = this.getPattern();
            if (instruction instanceof Reference) {
                Reference ref = (Reference)instruction;
                ref.setWrittenTo(true);
            }
        }

        public Instruction getPattern() {
            return this.pattern.get();
        }

        public Instruction getCondition() {
            return this.condition.get();
        }
    }
}

