/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.bytecode.insns.FieldDecl;
import net.covers1624.coffeegrinder.bytecode.insns.InvokeDynamic;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.ParameterVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Return;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.tags.CompactConstructorTag;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.ImplicitConstructorCleanup;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.AnnotationData;
import net.covers1624.coffeegrinder.type.AnnotationSupplier;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.Parameter;
import net.covers1624.coffeegrinder.type.TypeAnnotationData;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.JavaVersion;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class RecordTransformer
implements ClassTransformer {
    @Nullable
    private final ClassType objectMethods;

    public RecordTransformer(TypeResolver typeResolver) {
        this.objectMethods = typeResolver.tryResolveClassDecl("java/lang/runtime/ObjectMethods");
    }

    @Override
    public void transform(ClassDecl cInsn, ClassTransformContext ctx) {
        ClassType type = cInsn.getClazz();
        if (!type.isRecord() || this.objectMethods == null) {
            return;
        }
        ArrayList componentFields = cInsn.getFieldMembers().filterNot(e -> e.getField().isStatic()).toList();
        MethodDecl mainCtor = RecordTransformer.findMainConstructor(cInsn, componentFields);
        this.buildRecordComponents(cInsn, componentFields, mainCtor);
        ArrayList implicitMethods = FastStream.of((Object[])new MethodDecl[]{this.findDefaultMethod(cInsn, "toString", "()Ljava/lang/String;"), this.findDefaultMethod(cInsn, "hashCode", "()I"), this.findDefaultMethod(cInsn, "equals", "(Ljava/lang/Object;)Z")}).filter(Objects::nonNull).toList();
        this.detectAndStripImplicitAccessors(cInsn, (MethodDecl)FastStream.of((Iterable)implicitMethods).firstOrDefault(), ctx);
        implicitMethods.forEach(e -> RecordTransformer.removeDefaultMethod(e, ctx));
        this.transformCanonicalConstructor(cInsn, mainCtor, ctx);
    }

    private void buildRecordComponents(ClassDecl cInsn, List<FieldDecl> componentFields, MethodDecl mainCtor) {
        for (int index = 0; index < componentFields.size(); ++index) {
            FieldDecl fieldDecl = componentFields.get(index);
            Field field = fieldDecl.getField();
            AType type = field.getType();
            String name = field.getName();
            MethodDecl accessor = (MethodDecl)cInsn.getMethodMembers().filter(e -> e.getMethod().getName().equals(name) && e.getMethod().getParameters().isEmpty() && e.getMethod().getReturnType().equals(type)).only();
            TypeAnnotationData typeAnnotations = new TypeAnnotationData();
            ArrayList<AnnotationData> regularAnnotations = new ArrayList<AnnotationData>();
            field.getAnnotationSupplier().parseTypeAnnotations(typeAnnotations, AnnotationSupplier.TypeAnnotationLocation.FIELD, type, 0);
            mainCtor.getMethod().getAnnotationSupplier().parseTypeAnnotations(typeAnnotations, AnnotationSupplier.TypeAnnotationLocation.PARAMETER, type, index);
            field.getAnnotationSupplier().parseAnnotations(regularAnnotations, typeAnnotations);
            Parameter parameter = mainCtor.getMethod().getParameters().get(index);
            parameter.getAnnotationSupplier().parseAnnotations(regularAnnotations, typeAnnotations);
            cInsn.recordComponents.add(new ClassDecl.RecordComponentDecl(fieldDecl, index == componentFields.size() - 1 && mainCtor.getMethod().getAccessFlags().get(AccessFlag.VARARGS), accessor, typeAnnotations, regularAnnotations));
        }
    }

    private void detectAndStripImplicitAccessors(ClassDecl cInsn, @Nullable MethodDecl firstImplicitMethod, ClassTransformContext ctx) {
        for (ClassDecl.RecordComponentDecl component : cInsn.recordComponents.reversed()) {
            Field field = component.field.getField();
            AType type = field.getType();
            assert (component.accessor != null);
            if (!this.isAccessorBodySynthetic(component.accessor, component.field)) continue;
            AnnotationSupplier supplier = component.accessor.getMethod().getAnnotationSupplier();
            TypeAnnotationData tAnnotations = new TypeAnnotationData();
            ArrayList<AnnotationData> rAnnotations = new ArrayList<AnnotationData>();
            supplier.parseTypeAnnotations(tAnnotations, AnnotationSupplier.TypeAnnotationLocation.METHOD_RETURN, type, 0);
            supplier.parseAnnotations(rAnnotations, tAnnotations);
            if (!this.canMergeAnnotations(component, rAnnotations, tAnnotations) || firstImplicitMethod != null && !RecordTransformer.isDeclaredLater(component.accessor, firstImplicitMethod) || firstImplicitMethod == null && component.accessor.getNextSiblingOrNull() instanceof MethodDecl) continue;
            supplier.parseTypeAnnotations(component.typeAnnotations, AnnotationSupplier.TypeAnnotationLocation.METHOD_RETURN, type, 0);
            supplier.parseAnnotations(component.regularAnnotations, component.typeAnnotations);
            ctx.pushStep("Remove default accessor for: " + component.field.getField().getName());
            component.accessor.remove();
            component.accessor = null;
            ctx.popStep();
        }
    }

    private boolean isAccessorBodySynthetic(MethodDecl accessor, FieldDecl fieldDecl) {
        Instruction instruction = accessor.getBody().getEntryPoint().getFirstChildOrNull();
        if (!(instruction instanceof Return)) {
            return false;
        }
        Return ret = (Return)instruction;
        return LoadStoreMatching.matchLoadField(ret.getValue(), fieldDecl.getField()) != null;
    }

    private boolean canMergeAnnotations(ClassDecl.RecordComponentDecl component, List<AnnotationData> rAnnotations, TypeAnnotationData tAnnotations) {
        List<AnnotationData> componentTypeAnnotations = component.typeAnnotations.getLeftMost().annotations;
        List<AnnotationData> methodTypeAnnotations = tAnnotations.getLeftMost().annotations;
        if (this.areAnnotationsIncompatible(rAnnotations, component.regularAnnotations, ElementType.FIELD, ElementType.PARAMETER)) {
            return false;
        }
        if (this.areAnnotationsIncompatible(methodTypeAnnotations, componentTypeAnnotations, ElementType.FIELD, ElementType.PARAMETER)) {
            return false;
        }
        if (this.areAnnotationsIncompatible(component.regularAnnotations, rAnnotations, ElementType.METHOD)) {
            return false;
        }
        return !this.areAnnotationsIncompatible(componentTypeAnnotations, methodTypeAnnotations, ElementType.METHOD);
    }

    private boolean areAnnotationsIncompatible(List<AnnotationData> toCheck, List<AnnotationData> target, ElementType ... targetLocations) {
        for (AnnotationData annotation : toCheck) {
            if (target.contains(annotation) || !this.doesApplyTo(annotation, targetLocations)) continue;
            return true;
        }
        return false;
    }

    private boolean doesApplyTo(AnnotationData annotation, ElementType ... required) {
        List<ElementType> types = annotation.type().getAnnotationTargets();
        if (types.isEmpty()) {
            return true;
        }
        for (ElementType type : required) {
            if (!types.contains((Object)type)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private MethodDecl findDefaultMethod(ClassDecl cInsn, String mName, String desc) {
        assert (this.objectMethods != null);
        MethodDecl method = cInsn.getMethod(mName, Type.getMethodType((String)desc));
        Instruction instruction = method.getBody().getEntryPoint().getFirstChildOrNull();
        if (!(instruction instanceof Return)) {
            return null;
        }
        Return ret = (Return)instruction;
        InvokeDynamic indy = InvokeMatching.matchInvokeDynamic(ret.getValue(), this.objectMethods, "bootstrap");
        if (indy == null || !indy.name.equals(mName)) {
            return null;
        }
        return method;
    }

    private static void removeDefaultMethod(@Nullable MethodDecl method, ClassTransformContext ctx) {
        if (method == null) {
            return;
        }
        ctx.pushStep("Remove default " + method.getMethod().getName() + " method.");
        method.remove();
        ctx.popStep();
    }

    private void transformCanonicalConstructor(ClassDecl cInsn, MethodDecl ctor, ClassTransformContext ctx) {
        boolean hasUserCode;
        Store store;
        ctx.pushStep("Remove redundant super call.");
        ImplicitConstructorCleanup.removeRedundantSuperCall(ctor);
        ctx.popStep();
        ArrayList recordMembers = cInsn.getFieldMembers().filter(e -> !e.getField().isStatic()).toList();
        ArrayList parameters = ctor.parameters.toList();
        Instruction insn = ((Block)ctor.getBody().blocks.last()).getLastChildOrNull();
        if (!(insn instanceof Return)) {
            return;
        }
        insn = insn.getPrevSiblingOrNull();
        ArrayList<Store> stores = new ArrayList<Store>(recordMembers.size());
        int i = recordMembers.size() - 1;
        while (i >= 0 && (store = LoadStoreMatching.matchStoreField(insn, ((FieldDecl)recordMembers.get(i)).getField())) != null && LoadStoreMatching.matchLoadLocal(store.getValue(), (LocalVariable)parameters.get(i)) != null) {
            stores.add(store);
            --i;
            insn = insn.getPrevSiblingOrNull();
        }
        boolean bl = hasUserCode = insn != null;
        if (stores.size() != recordMembers.size()) {
            return;
        }
        if (ColUtils.anyMatch((Iterable)parameters, e -> e.parameter.isFinal())) {
            return;
        }
        Optional<Boolean> forceCompact = Optional.empty();
        if (ctx.classVersion.isAtLeast(JavaVersion.JAVA_21) && !parameters.isEmpty()) {
            forceCompact = Optional.of(((ParameterVariable)parameters.getFirst()).parameter.isMandated());
        }
        if (!(forceCompact.orElse(false).booleanValue() || hasUserCode || RecordTransformer.areFlagsDifferent(cInsn, ctor))) {
            ctx.pushStep("Delete canonical constructor.");
            ctor.remove();
            ctx.popStep();
        } else if (forceCompact.orElse(true).booleanValue()) {
            ctx.pushStep("Create compact record constructor.");
            stores.forEach(Instruction::remove);
            ctor.setTag(new CompactConstructorTag());
            ctx.popStep();
        }
    }

    private static boolean areFlagsDifferent(ClassDecl cDecl, MethodDecl mDecl) {
        return AccessFlag.getAccess(cDecl.getClazz().getAccessFlags()) != AccessFlag.getAccess(mDecl.getMethod().getAccessFlags());
    }

    private static MethodDecl findMainConstructor(ClassDecl cInsn, List<FieldDecl> componentFields) {
        return (MethodDecl)cInsn.getMethodMembers().filter(e -> e.getMethod().getName().equals("<init>")).filter(e -> RecordTransformer.matchParameterTypes(e.getMethod().getParameters(), componentFields)).only();
    }

    private static boolean matchParameterTypes(List<Parameter> parameters, List<FieldDecl> componentFields) {
        if (parameters.size() != componentFields.size()) {
            return false;
        }
        for (int i = 0; i < componentFields.size(); ++i) {
            if (componentFields.get(i).getField().getType().equals(parameters.get(i).getType())) continue;
            return false;
        }
        return true;
    }

    private static boolean isDeclaredLater(Instruction a, Instruction b) {
        while (b != null) {
            if (b == a) {
                return true;
            }
            b = b.getNextSiblingOrNull();
        }
        return false;
    }
}

