/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers.statement;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.LdcClass;
import net.covers1624.coffeegrinder.bytecode.insns.LdcInsn;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNull;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.ParameterVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.tags.PotentialConstantLookupTag;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformer;
import net.covers1624.coffeegrinder.type.ClassType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class GeneratedNullChecks
implements StatementTransformer {
    private StatementTransformContext ctx;

    @Override
    public void transform(Instruction statement, StatementTransformContext ctx) {
        this.ctx = ctx;
        Store deadStore = this.matchDeadStore(statement);
        if (deadStore == null) {
            return;
        }
        Instruction value = deadStore.getValue();
        Load nullChecked = GeneratedNullChecks.matchNullCheck(value);
        if (nullChecked != null && nullChecked.dup && this.removeSyntheticNullCheck(deadStore, nullChecked)) {
            return;
        }
        this.tagPotentialConstantLookup(statement, value, nullChecked);
    }

    @Nullable
    private Store matchDeadStore(Instruction statement) {
        Instruction prev = statement.getPrevSiblingOrNull();
        if (prev == null) {
            return null;
        }
        Store deadStore = LoadStoreMatching.matchStoreLocal(prev);
        if (deadStore == null) {
            return null;
        }
        LocalVariable var = deadStore.getVariable();
        if (!var.isSynthetic() || var.getReferenceCount() > 1) {
            return null;
        }
        return deadStore;
    }

    private boolean removeSyntheticNullCheck(Instruction deadStore, Load nullChecked) {
        LocalVariable var = nullChecked.getVariable();
        if (var.getKind() != LocalVariable.VariableKind.STACK_SLOT) {
            return false;
        }
        Instruction prev = deadStore.getPrevSiblingOrNull();
        this.ctx.pushStep("Remove synthetic null check");
        this.ctx.moveNext();
        deadStore.remove();
        if (var.getLoadCount() == 0) {
            assert (prev != null);
            assert (LoadStoreMatching.matchStoreLocal(prev, var) != null);
            this.ctx.moveNext();
            prev.remove();
        }
        this.ctx.popStep();
        return true;
    }

    @Nullable
    private Store isStoredFromMandatedParameter(Load stackLoad) {
        Load paramLoad;
        block5: {
            block4: {
                paramLoad = LoadStoreMatching.matchLoadLocal(LoadStoreMatching.matchPushForPop(stackLoad));
                if (paramLoad == null) {
                    return null;
                }
                LocalVariable variable = paramLoad.getVariable();
                if (!(variable instanceof ParameterVariable)) break block4;
                ParameterVariable pv = (ParameterVariable)variable;
                if (pv.parameter.isMandated()) break block5;
            }
            return null;
        }
        return (Store)paramLoad.getParent();
    }

    private void tagPotentialConstantLookup(Instruction statement, Instruction deadStoreValue, @Nullable Instruction nullCheckedValue) {
        Instruction target;
        Store store = LoadStoreMatching.matchStoreLocal(statement);
        if (store == null) {
            return;
        }
        Instruction instruction = store.getValue();
        if (!(instruction instanceof LdcInsn)) {
            return;
        }
        LdcInsn ldc = (LdcInsn)instruction;
        if (ldc instanceof LdcNull || ldc instanceof LdcClass) {
            return;
        }
        boolean isStatic = nullCheckedValue == null;
        Instruction instruction2 = target = isStatic ? deadStoreValue : nullCheckedValue;
        if (!(target.getResultType() instanceof ClassType)) {
            return;
        }
        this.ctx.pushStep("Tag ldc: " + String.valueOf(ldc.getRawValue()));
        deadStoreValue.setTag(new PotentialConstantLookupTag(isStatic, ldc));
        this.ctx.popStep();
    }

    @Nullable
    @Contract(value="null->null")
    public static Load matchNullCheck(@Nullable Instruction statement) {
        if (statement == null) {
            return null;
        }
        Invoke invoke = InvokeMatching.matchInvoke(statement, Invoke.InvokeKind.VIRTUAL, "getClass", Type.getMethodType((String)"()Ljava/lang/Class;"));
        if (invoke != null) {
            return LoadStoreMatching.matchLoadLocal(invoke.getTarget());
        }
        invoke = InvokeMatching.matchInvoke(statement, Invoke.InvokeKind.STATIC, "requireNonNull", Type.getMethodType((String)"(Ljava/lang/Object;)Ljava/lang/Object;"));
        if (invoke != null) {
            return LoadStoreMatching.matchLoadLocal((Instruction)invoke.getArguments().first());
        }
        return null;
    }
}

