/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.compilerserver;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.javasauce.compilerserver.LocalCompiler;
import net.javasauce.compilerserver.RemoteCompiler;
import org.jetbrains.annotations.Nullable;

public interface Compiler
extends AutoCloseable {
    public static Compiler of(Path javaExecutable, Collection<Path> compileClasspath) throws IOException {
        return Compiler.of(javaExecutable, Collections.emptyList(), compileClasspath);
    }

    public static Compiler of(Path javaExecutable, List<String> jvmArgs, Collection<Path> compileClasspath) throws IOException {
        return new RemoteCompiler(javaExecutable, jvmArgs, compileClasspath);
    }

    public static Compiler forLocal(Collection<Path> compileClasspath) throws IOException {
        return new LocalCompiler(compileClasspath);
    }

    public CompileResult compile(URI var1, String var2, List<String> var3);

    @Override
    public void close() throws IOException;

    public static class CompileResult
    implements Serializable {
        public final Map<String, byte[]> output;
        public final boolean success;
        public final String compileLog;
        @Nullable
        public final Throwable javacCrash;

        public CompileResult(Map<String, byte[]> output, boolean success, String compileLog, @Nullable Throwable javacCrash) {
            this.output = output;
            this.success = success;
            this.compileLog = compileLog;
            this.javacCrash = javacCrash;
        }
    }
}

