/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.ParameterVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Reference;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.AnnotationSupplier;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public class LocalVariable
extends Instruction {
    private final VariableKind kind;
    @Nullable
    private String genericSignature;
    private AType type;
    private final int index;
    private String name;
    private int subId;
    private final List<LocalReference> references = new LinkedList<LocalReference>();
    private boolean isSynthetic;
    private AnnotationSupplier annotationSupplier = AnnotationSupplier.EMPTY;

    public LocalVariable(VariableKind kind, AType type, String name) {
        this(kind, type, null, -1, name);
    }

    public LocalVariable(VariableKind kind, AType type, @Nullable String genericSignature, int index, String name) {
        this.kind = kind;
        this.type = type;
        this.genericSignature = genericSignature;
        this.index = index;
        this.name = name;
        boolean bl = this.isSynthetic = kind == VariableKind.STACK_SLOT;
        assert (kind != VariableKind.LOCAL && kind != VariableKind.PARAMETER ? index == -1 : index >= 0);
        assert (kind != VariableKind.PARAMETER || this instanceof ParameterVariable);
    }

    public void addReference(LocalReference insn) {
        this.references.add(insn);
        if (!this.isConnected()) {
            throw new UnsupportedOperationException("Cannot add reference to a disconnected variable.");
        }
    }

    public void removeReference(LocalReference insn) {
        this.references.remove(insn);
        if (this.isDead() && this.isConnected()) {
            this.remove();
        }
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitLocalVariable(this, ctx);
    }

    @Override
    public AType getResultType() {
        throw new UnsupportedOperationException();
    }

    public VariableKind getKind() {
        return this.kind;
    }

    @Nullable
    public String getGenericSignature() {
        return this.genericSignature;
    }

    public AType getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public int getSubId() {
        return this.subId;
    }

    public List<LocalReference> getReferences() {
        return Collections.unmodifiableList(this.references);
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    public AnnotationSupplier getAnnotationSupplier() {
        return this.annotationSupplier;
    }

    public void setGenericSignature(@Nullable String genericSignature) {
        this.genericSignature = genericSignature;
    }

    public void setType(AType type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSubId(int subId) {
        this.subId = subId;
    }

    public void setSynthetic(boolean synthetic) {
        this.isSynthetic = synthetic;
    }

    public void setAnnotationSupplier(AnnotationSupplier annotationSupplier) {
        this.annotationSupplier = annotationSupplier;
    }

    public int getLoadCount() {
        return FastStream.of(this.references).filter(Reference::isReadFrom).count();
    }

    public int getStoreCount() {
        return FastStream.of(this.references).filter(Reference::isWrittenTo).count();
    }

    public int getReferenceCount() {
        return this.references.size();
    }

    public boolean isDead() {
        return this.kind != VariableKind.PARAMETER && this.references.isEmpty();
    }

    public String getUniqueName() {
        if (this.getSubId() > 0) {
            return this.getName() + "$" + this.getSubId();
        }
        return this.getName();
    }

    public static enum VariableKind {
        LOCAL,
        PARAMETER,
        STACK_SLOT,
        TEMP_LOCAL;

    }
}

