/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers.statement;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.InstanceOf;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LogicAnd;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.tags.RecordPatternComponentTag;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformer;
import net.covers1624.coffeegrinder.util.None;
import net.covers1624.quack.collection.FastStream;

public class RecordPatternSimplification
extends SimpleInsnVisitor<StatementTransformContext>
implements StatementTransformer {
    @Override
    public void transform(Instruction statement, StatementTransformContext ctx) {
        statement.accept(this, ctx);
    }

    @Override
    public None visitLogicAnd(LogicAnd logicAnd, StatementTransformContext ctx) {
        super.visitLogicAnd(logicAnd, ctx);
        if (this.tryInline(logicAnd.getLeft(), logicAnd.getRight(), ctx)) {
            return NONE;
        }
        if (this.tryInline(logicAnd.getRight(), logicAnd.getLeft(), ctx)) {
            return NONE;
        }
        return NONE;
    }

    private boolean tryInline(Instruction target, Instruction remainder, StatementTransformContext ctx) {
        Load load;
        InstanceOf instanceOf;
        if (!(target instanceof InstanceOf) || (instanceOf = (InstanceOf)target).getPattern() instanceof Nop) {
            return false;
        }
        Load load2 = LoadStoreMatching.matchLoadLocal(instanceOf.getArgument());
        if (!(load2 instanceof Load) || !((load = load2).getTag() instanceof RecordPatternComponentTag)) {
            return false;
        }
        LocalReference otherRef = (LocalReference)FastStream.of(load.getVariable().getReferences()).filter(e -> e != load.getReference()).only();
        ctx.pushStep("Inline nested record pattern");
        otherRef.replaceWith(instanceOf.getPattern());
        target.getParent().replaceWith(remainder);
        ctx.popStep();
        return true;
    }
}

