/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.covers1624.coffeegrinder.DecompilerSettings;
import net.covers1624.coffeegrinder.bytecode.ClassProcessor;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.debug.NullStepper;
import net.covers1624.coffeegrinder.source.JavaSourceVisitor;
import net.covers1624.coffeegrinder.source.LineBuffer;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.type.asm.AsmClass;
import net.covers1624.coffeegrinder.util.jvm.JVMUtils;
import net.covers1624.coffeegrinder.util.resolver.ClassResolver;
import net.covers1624.coffeegrinder.util.resolver.Resolver;
import net.covers1624.quack.collection.FastStream;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoffeeGrinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoffeeGrinder.class);
    private static final IntSet KNOWN_SUPPORTED = IntArraySet.of((int[])new int[]{8, 9, 10, 11, 12, 13, 14, 15, 16, 17});

    public static void main(String[] args) throws Throwable {
        System.exit(CoffeeGrinder.mainI(args));
    }

    public static int mainI(String[] args) throws Throwable {
        Path astOutput;
        Path sourceOutput;
        OptionParser parser = new OptionParser();
        NonOptionArgumentSpec nonOptions = parser.nonOptions();
        AbstractOptionSpec helpOpt = parser.acceptsAll(Arrays.asList("h", "help"), "Prints this help").forHelp();
        ArgumentAcceptingOptionSpec inputOpt = parser.acceptsAll(Arrays.asList("i", "input"), "Sets the input directory.").withRequiredArg().required().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        ArgumentAcceptingOptionSpec outSourceOpt = parser.acceptsAll(Arrays.asList("o", "output"), "Specifies the location to dump output source files.").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        ArgumentAcceptingOptionSpec outAstOpt = parser.acceptsAll(Arrays.asList("a", "output-ast"), "Specifies the location to dump output AST files.").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        ArgumentAcceptingOptionSpec libsOpt = parser.acceptsAll(Arrays.asList("l", "lib"), "Specifies an optional library for context.").withRequiredArg().withValuesSeparatedBy(File.pathSeparatorChar).withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        ArgumentAcceptingOptionSpec threadsOpt = parser.acceptsAll(Arrays.asList("t", "threads"), "Specifies the number of threads to use when decompiling. The default value will be the number of cores - 1. To disable threading set to 1.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)(Runtime.getRuntime().availableProcessors() - 1), (Object[])new Integer[0]);
        OptionSet optSet = parser.parse(args);
        if (optSet.has((OptionSpec)helpOpt)) {
            parser.printHelpOn((OutputStream)System.err);
            return -1;
        }
        Path inputPath = (Path)optSet.valueOf((OptionSpec)inputOpt);
        if (Files.notExists(inputPath, new LinkOption[0])) {
            LOGGER.error("Expected '--input' path to exist.");
            parser.printHelpOn((OutputStream)System.err);
            return -1;
        }
        if (optSet.has((OptionSpec)outSourceOpt)) {
            sourceOutput = (Path)optSet.valueOf((OptionSpec)outSourceOpt);
            if (Files.exists(sourceOutput, new LinkOption[0]) && !Files.isDirectory(sourceOutput, new LinkOption[0])) {
                LOGGER.error("Expected '--output' to be a folder.");
                parser.printHelpOn((OutputStream)System.err);
                return -1;
            }
        } else {
            sourceOutput = null;
        }
        if (optSet.has((OptionSpec)outAstOpt)) {
            astOutput = (Path)optSet.valueOf((OptionSpec)outAstOpt);
            if (Files.exists(astOutput, new LinkOption[0]) && !Files.isDirectory(astOutput, new LinkOption[0])) {
                LOGGER.error("Expected '--output-ast' to be a folder.");
                parser.printHelpOn((OutputStream)System.err);
                return -1;
            }
        } else {
            astOutput = null;
        }
        if (sourceOutput == null && astOutput == null) {
            LOGGER.error("Expected '--output' or '--output-ast'.");
            return -1;
        }
        int threads = (Integer)optSet.valueOf((OptionSpec)threadsOpt);
        if (threads < 1) {
            LOGGER.error("Expected '--threads' value to be greater than 1.");
            parser.printHelpOn((OutputStream)System.err);
            return -1;
        }
        ClassResolver classResolver = new ClassResolver();
        JVMUtils.addRuntimeJREToResolver(classResolver);
        for (Path path : optSet.valuesOf((OptionSpec)libsOpt)) {
            classResolver.addResolver(path);
        }
        classResolver.setTarget(inputPath);
        TypeResolver typeResolver = new TypeResolver(classResolver);
        DecompilerSettings settings = new DecompilerSettings();
        Resolver resolver = classResolver.getTargetResolver();
        ExecutorService executor = Executors.newFixedThreadPool(threads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Decompile Thread %d").build());
        LinkedList classes = resolver.getAllClasses().toLinkedList();
        LOGGER.info("Decompiling {} classes.", (Object)classes.size());
        IntArraySet warnedUnsupportedClassVersions = new IntArraySet();
        long start = System.nanoTime();
        List failures = Collections.synchronizedList(new LinkedList());
        for (String clazz : classes) {
            ClassType clazzType;
            if (clazz.endsWith("module-info") || (clazzType = typeResolver.resolveClassDecl(clazz)).getDeclType() != ClassType.DeclType.TOP_LEVEL) continue;
            int classVersion = (((AsmClass)clazzType).getNode().getPartialNode().version & 0xFF) - 44;
            if (!KNOWN_SUPPORTED.contains(classVersion) && warnedUnsupportedClassVersions.add(classVersion)) {
                LOGGER.warn("Found classes compiled for java {}, this version is not known to be supported yet. Things may break.", (Object)classVersion);
            }
            executor.submit(() -> {
                try {
                    ClassProcessor processor = new ClassProcessor(typeResolver, clazzType, settings);
                    ClassDecl decl = processor.process(NullStepper.INSTANCE);
                    if (astOutput != null) {
                        Path output = astOutput.resolve(clazz + ".ast");
                        Files.createDirectories(output.getParent(), new FileAttribute[0]);
                        Files.write(output, decl.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    }
                    if (sourceOutput != null) {
                        LineBuffer lines = decl.accept(new JavaSourceVisitor(typeResolver));
                        Path output = sourceOutput.resolve(clazz + ".java");
                        Files.createDirectories(output.getParent(), new FileAttribute[0]);
                        Files.write(output, String.join((CharSequence)"\n", lines.lines).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    }
                }
                catch (Throwable e) {
                    failures.add(Pair.of((Object)clazz, (Object)e));
                    LOGGER.error("Failed to decompile: {}", (Object)clazz, (Object)e);
                }
            });
        }
        executor.shutdown();
        while (!executor.awaitTermination(5L, TimeUnit.MINUTES)) {
            LOGGER.info("Waiting for tasks...");
        }
        int numFailures = failures.size();
        if (numFailures > 0) {
            LOGGER.error("{} classes failed.", (Object)numFailures);
            LOGGER.info("Exception report:");
            FastStream.of(failures).groupBy(e -> {
                Throwable ex = (Throwable)e.getRight();
                StackTraceElement[] trace = ex.getStackTrace();
                StringBuilder builder = new StringBuilder();
                builder.append(ex.getClass().getName()).append(" ").append(ex.getMessage());
                if (trace.length == 0) {
                    builder.append(" No stack trace");
                } else {
                    int numTrace = Math.min(2, trace.length);
                    for (int i = 0; i < numTrace; ++i) {
                        builder.append("\n\tat ").append(trace[i]);
                    }
                }
                return builder.toString();
            }).sorted(Comparator.comparingInt(e -> -e.count())).forEach(g -> {
                String first3 = g.limit(3).map(Pair::getLeft).join("\n");
                LOGGER.info("{}\n{}\n{}\n", new Object[]{g.count(), first3, g.getKey()});
            });
        }
        long end = System.nanoTime();
        LOGGER.info("Finished. Took {}", (Object)CoffeeGrinder.formatDuration(end - start));
        return numFailures > 0 ? 1 : 0;
    }

    public static String formatDuration(long elapsedTimeInNs) {
        StringBuilder result = new StringBuilder();
        if (elapsedTimeInNs >= 3600000000000L) {
            result.append(elapsedTimeInNs / 3600000000000L).append("h ");
        }
        if (elapsedTimeInNs >= 60000000000L) {
            result.append(elapsedTimeInNs % 3600000000000L / 60000000000L).append("m ");
        }
        if (elapsedTimeInNs >= 1000000000L) {
            result.append(elapsedTimeInNs % 60000000000L / 1000000000L).append("s ");
        }
        if (elapsedTimeInNs < 1000000L) {
            return "< 1ms";
        }
        result.append(elapsedTimeInNs % 1000000000L / 1000000L).append("ms");
        return result.toString();
    }
}

