/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.flow;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Color;
import guru.nidi.graphviz.attribute.Rank;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.Node;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;

public class ControlFlowNode {
    public int cfgIndex;
    @Nullable
    public Block block;
    public boolean visited;
    public int postOrderNumber;
    private final List<ControlFlowNode> predecessors = new ArrayList<ControlFlowNode>();
    private final List<ControlFlowNode> successors = new ArrayList<ControlFlowNode>();
    @Nullable
    ControlFlowNode immediateDominator;
    @Nullable
    List<ControlFlowNode> dominatorTreeChildren = null;

    public ControlFlowNode() {
    }

    public ControlFlowNode(int cfgIndex) {
        this.cfgIndex = cfgIndex;
    }

    public ControlFlowNode(ControlFlowNode other) {
        this.cfgIndex = other.cfgIndex;
        this.block = other.block;
    }

    public ControlFlowNode(int cfgIndex, Block block) {
        this.cfgIndex = cfgIndex;
        this.block = block;
    }

    public void addEdgeTo(ControlFlowNode target) {
        this.successors.add(target);
        target.predecessors.add(this);
    }

    public void traversePreOrder(Function<ControlFlowNode, List<ControlFlowNode>> children, Consumer<ControlFlowNode> visitor) {
        if (this.visited) {
            return;
        }
        this.visited = true;
        visitor.accept(this);
        for (ControlFlowNode t : children.apply(this)) {
            t.traversePreOrder(children, visitor);
        }
    }

    public void traversePostOrder(Function<ControlFlowNode, List<ControlFlowNode>> children, Consumer<ControlFlowNode> visitor) {
        if (this.visited) {
            return;
        }
        this.visited = true;
        for (ControlFlowNode t : children.apply(this)) {
            t.traversePostOrder(children, visitor);
        }
        visitor.accept(this);
    }

    public boolean dominates(ControlFlowNode node) {
        ControlFlowNode tmp = node;
        while (tmp != null) {
            if (tmp == this) {
                return true;
            }
            tmp = tmp.immediateDominator;
        }
        return false;
    }

    public FastStream<ControlFlowNode> streamPreOrder(Function<ControlFlowNode, FastStream<ControlFlowNode>> children) {
        return FastStream.of((Object)this).concat((Iterable)children.apply(this).flatMap(e -> e.streamPreOrder(children)));
    }

    public FastStream<ControlFlowNode> streamPostOrder(Function<ControlFlowNode, FastStream<ControlFlowNode>> children) {
        return children.apply(this).flatMap(e -> e.streamPostOrder(children)).concat((Iterable)FastStream.of((Object)this));
    }

    public Block getBlock() {
        return Objects.requireNonNull(this.block);
    }

    public List<ControlFlowNode> getPredecessors() {
        return this.predecessors;
    }

    public List<ControlFlowNode> getSuccessors() {
        return this.successors;
    }

    public ControlFlowNode getImmediateDominator() {
        return Objects.requireNonNull(this.getImmediateDominatorOrNull());
    }

    @Nullable
    public ControlFlowNode getImmediateDominatorOrNull() {
        return this.immediateDominator;
    }

    public List<ControlFlowNode> getDominatorTreeChildren() {
        return Objects.requireNonNull(this.dominatorTreeChildren);
    }

    public boolean isReachable() {
        return this.dominatorTreeChildren != null;
    }

    public String toString() {
        if (this.block == null) {
            return "Block at: UNKNOWN";
        }
        return "Block at: " + this.block.getName();
    }

    private Graph addToGraph(Graph g, Set<ControlFlowNode> visited, Function<ControlFlowNode, String> namer) {
        if (!visited.add(this)) {
            return g;
        }
        String name = namer.apply(this);
        Node node = Factory.node((String)name);
        if (this.immediateDominator != null) {
            g = g.with(new LinkSource[]{Factory.node((String)namer.apply(this.immediateDominator)).link(new LinkTarget[]{Factory.to((Node)node).with((Attributes)Color.LIMEGREEN)})});
        }
        for (ControlFlowNode n : this.successors) {
            g = n.addToGraph(g, visited, namer);
            node = node.link(namer.apply(n));
        }
        g = g.with(new LinkSource[]{node});
        for (ControlFlowNode n : this.predecessors) {
            g = n.addToGraph(g, visited, namer);
        }
        return g;
    }

    public static Graph makeGraph(ControlFlowNode entry) {
        Graph graph = (Graph)((Graph)Factory.graph().directed().graphAttr().with((Attributes)Rank.dir((Rank.RankDir)Rank.RankDir.TOP_TO_BOTTOM))).linkAttr().with("class", (Object)"link-class");
        HashSet<ControlFlowNode> visited = new HashSet<ControlFlowNode>();
        HashMap unnamedNodes = new HashMap();
        graph = entry.addToGraph(graph, visited, e -> e.block != null ? e.block.getName() : unnamedNodes.computeIfAbsent(e, e2 -> "#" + unnamedNodes.size()));
        return graph;
    }

    private void evalDumpGraph() {
        this.evalDumpGraph("eval_graph");
    }

    private void evalDumpGraph(String name) {
        SneakyUtils.sneaky(() -> Graphviz.fromGraph((Graph)ControlFlowNode.makeGraph(this)).scale(2.0).render(Format.PNG).toFile(new File("graphs/" + name + ".png")));
    }
}

