/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.flow;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import net.covers1624.coffeegrinder.bytecode.flow.ControlFlowNode;

public class Dominance {
    public static void computeDominance(ControlFlowNode entryPoint) {
        boolean changed;
        ArrayList nodes = new ArrayList();
        entryPoint.traversePostOrder(ControlFlowNode::getSuccessors, nodes::add);
        assert (nodes.get(nodes.size() - 1) == entryPoint);
        for (int i = 0; i < nodes.size(); ++i) {
            ((ControlFlowNode)nodes.get((int)i)).postOrderNumber = i;
        }
        entryPoint.immediateDominator = entryPoint;
        do {
            changed = false;
            for (int i = nodes.size() - 2; i >= 0; --i) {
                ControlFlowNode b = (ControlFlowNode)nodes.get(i);
                ControlFlowNode newIdom = null;
                for (ControlFlowNode p : b.getPredecessors()) {
                    if (p.immediateDominator == null) continue;
                    if (newIdom == null) {
                        newIdom = p;
                        continue;
                    }
                    newIdom = Dominance.findCommonDominator(p, newIdom);
                }
                assert (newIdom != null);
                if (newIdom == b.immediateDominator) continue;
                b.immediateDominator = newIdom;
                changed = true;
            }
        } while (changed);
        for (ControlFlowNode node : nodes) {
            if (node.immediateDominator == null) continue;
            node.dominatorTreeChildren = new ArrayList<ControlFlowNode>();
        }
        entryPoint.immediateDominator = null;
        for (ControlFlowNode node : nodes) {
            if (node.immediateDominator != null) {
                assert (node.immediateDominator.dominatorTreeChildren != null);
                node.immediateDominator.dominatorTreeChildren.add(node);
            }
            node.visited = false;
        }
    }

    public static ControlFlowNode findCommonDominator(ControlFlowNode a, ControlFlowNode b) {
        while (a != b) {
            while (a.postOrderNumber < b.postOrderNumber) {
                a = a.getImmediateDominator();
            }
            while (b.postOrderNumber < a.postOrderNumber) {
                b = b.getImmediateDominator();
            }
        }
        return a;
    }

    public static void computeReachableExits(BitSet bits, ControlFlowNode[] cfg) {
        assert (Dominance.assertNodeIndex(cfg));
        for (ControlFlowNode j : cfg) {
            if (!j.isReachable() || j.getPredecessors().size() < 2 && (j.getPredecessors().size() < 1 || j.immediateDominator != null)) continue;
            Iterator<ControlFlowNode> iterator = j.getPredecessors().iterator();
            while (iterator.hasNext()) {
                ControlFlowNode p;
                ControlFlowNode runner = p = iterator.next();
                while (runner != j.immediateDominator && runner != j && runner != null) {
                    bits.set(runner.cfgIndex);
                    runner = runner.immediateDominator;
                }
            }
        }
    }

    private static boolean assertNodeIndex(ControlFlowNode[] cfg) {
        for (int i = 0; i < cfg.length; ++i) {
            assert (cfg[i].cfgIndex == i);
        }
        return true;
    }
}

