/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

public class Compare
extends Instruction {
    private final Kind kind;
    private final InstructionSlot<Instruction> left = new InstructionSlot(this);
    private final InstructionSlot<Instruction> right = new InstructionSlot(this);

    public Compare(Kind kind, Instruction left, Instruction right) {
        super(InsnOpcode.COMPARE);
        this.kind = kind;
        this.left.set(left);
        this.right.set(right);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.INT;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitCompare(this, ctx);
    }

    public Kind getKind() {
        return this.kind;
    }

    public Instruction getLeft() {
        return this.left.get();
    }

    public Instruction getRight() {
        return this.right.get();
    }

    public static enum Kind {
        LONG,
        NAN_L,
        NAN_G;

    }
}

