/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.insns.AbstractLoop;
import net.covers1624.coffeegrinder.bytecode.insns.SimpleInstruction;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import org.jetbrains.annotations.Nullable;

public class Continue
extends SimpleInstruction {
    private static final EnumBitSet<InstructionFlag> FLAGS = EnumBitSet.of((Enum[])new InstructionFlag[]{InstructionFlag.END_POINT_UNREACHABLE, InstructionFlag.MAY_BRANCH});
    private AbstractLoop loop;

    public Continue(AbstractLoop loop) {
        super(InsnOpcode.CONTINUE);
        this.loop = loop;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return FLAGS;
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitContinue(this, ctx);
    }

    public AbstractLoop getLoop() {
        return this.loop;
    }

    public void setLoop(AbstractLoop loop) {
        if (this.isConnected()) {
            this.loop.remContinue(this);
        }
        this.loop = loop;
        if (this.isConnected()) {
            this.loop.addContinue(this);
        }
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        this.loop.addContinue(this);
    }

    @Override
    protected void onDisconnected() {
        super.onDisconnected();
        this.loop.remContinue(this);
    }

    @Nullable
    public static Continue matchContinue(Instruction insn, AbstractLoop loop) {
        if (insn.opcode != InsnOpcode.CONTINUE) {
            return null;
        }
        Continue c = (Continue)insn;
        if (c.getLoop() != loop) {
            return null;
        }
        return c;
    }
}

