/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.LdcInsn;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.IntegerConstantType;
import net.covers1624.coffeegrinder.type.PrimitiveType;

public class LdcNumber
extends LdcInsn {
    private final Number value;
    private final AType resultType;

    public LdcNumber(Number value) {
        super(InsnOpcode.LDC_NUMBER);
        this.value = value;
        if (value instanceof Double) {
            this.resultType = PrimitiveType.DOUBLE;
        } else if (value instanceof Float) {
            this.resultType = PrimitiveType.FLOAT;
        } else if (value instanceof Integer) {
            this.resultType = new IntegerConstantType((Integer)value);
        } else {
            assert (value instanceof Long);
            this.resultType = PrimitiveType.LONG;
        }
    }

    @Override
    public AType getResultType() {
        return this.resultType;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitLdcNumber(this, ctx);
    }

    @Override
    public Instruction copy() {
        return new LdcNumber(this.value);
    }

    @Override
    public Number getRawValue() {
        return this.value;
    }

    public Number getValue() {
        return this.value;
    }

    public int intValue() {
        assert (this.value instanceof Integer);
        return this.value.intValue();
    }
}

