/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.LdcInsn;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;

public class LdcString
extends LdcInsn {
    private final ClassType stringType;
    private final String value;

    public LdcString(ClassType stringType, String value) {
        super(InsnOpcode.LDC_STRING);
        this.stringType = stringType;
        this.value = value;
    }

    @Override
    public AType getResultType() {
        return this.stringType;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitLdcString(this, ctx);
    }

    @Override
    public LdcString copy() {
        return new LdcString(this.stringType, this.value);
    }

    @Override
    public String getRawValue() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }
}

