/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.SwitchTable;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

public class Switch
extends Instruction {
    private final InstructionSlot<Instruction> value = new InstructionSlot(this);
    private final InstructionSlot<BlockContainer> body = new InstructionSlot(this);

    public Switch(Instruction value, BlockContainer body) {
        super(InsnOpcode.SWITCH);
        this.value.set(value);
        this.body.set(body);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    protected EnumBitSet<InstructionFlag> computeFlags() {
        EnumBitSet<InstructionFlag> flags = super.computeFlags();
        if (!this.getSwitchTable().isExhaustive()) {
            flags.clear(InstructionFlag.END_POINT_UNREACHABLE);
        }
        return flags;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitSwitch(this, ctx);
    }

    public Instruction getValue() {
        return this.value.get();
    }

    public BlockContainer getBody() {
        return this.body.get();
    }

    public SwitchTable getSwitchTable() {
        return (SwitchTable)this.getBody().getFirstChild().getFirstChild();
    }
}

