/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.Leave;
import net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.ConditionDetection;
import net.covers1624.quack.util.SneakyUtils;

public class LabelledBlocks
implements BlockTransformer {
    @Override
    public void transform(Block block, BlockTransformContext ctx) {
        while (this.makeLabelledBreakContainer(block, ctx)) {
        }
    }

    private boolean makeLabelledBreakContainer(Block block, BlockTransformContext ctx) {
        if (block.getLastChild().opcode == InsnOpcode.SWITCH_TABLE) {
            return false;
        }
        Block nextBlock = (Block)block.getNextSiblingOrNull();
        if (nextBlock == null) {
            return false;
        }
        if (!nextBlock.getBranches().allMatch(b -> b.isDescendantOf(block))) {
            return false;
        }
        ctx.pushStep("Wrap with container");
        BlockContainer cont = new BlockContainer();
        Instruction first = (Instruction)block.instructions.filter(i -> i.descendantsMatching(e -> BranchLeaveMatching.matchBranch(e, nextBlock)).anyMatch(SneakyUtils.trueP())).first();
        Block nested = block.extractRange(nextBlock.getName(), first, block.getLastChild());
        cont.blocks.add(nested);
        block.instructions.add(cont);
        ctx.pushStep("Rewrite branches to leaves");
        for (Branch b2 : nextBlock.getBranches().toList()) {
            b2.replaceWith(new Leave(cont));
        }
        block.instructions.add(new Branch(nextBlock));
        ctx.popStep();
        ctx.popStep();
        ConditionDetection.inlineExitBranch(block, ctx);
        return true;
    }
}

