/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNumber;
import net.covers1624.coffeegrinder.bytecode.insns.LdcString;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.Switch;
import net.covers1624.coffeegrinder.bytecode.insns.SwitchTable;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LdcMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public class SwitchOnString
implements MethodTransformer {
    @Override
    public void transform(MethodDecl function, MethodTransformContext ctx) {
        LinkedList switches = function.descendantsOfType(InsnOpcode.SWITCH).filter(e -> SwitchOnString.matchInvokeStringHashcode(e.getValue()) != null).toLinkedList();
        for (Switch synSwitch : switches) {
            ctx.pushStep("Transform switch-on-string");
            this.processSyntheticSwitch(synSwitch);
            ctx.popStep();
        }
    }

    private void processSyntheticSwitch(Switch synSwitch) {
        Object section;
        Invoke hashCodeInvoke = (Invoke)synSwitch.getValue();
        Store synVarStore = Objects.requireNonNull(LoadStoreMatching.matchStoreLocal(synSwitch.getPrevSibling()));
        assert (LdcMatching.matchLdcInt(synVarStore.getValue(), -1) != null);
        LocalVariable synVar = synVarStore.getVariable();
        assert (synVar.getLoadCount() == 1);
        Store strVarStore = Objects.requireNonNull(LoadStoreMatching.matchStoreLocal(synVarStore.getPrevSibling()));
        LocalVariable strVar = strVarStore.getVariable();
        assert (LoadStoreMatching.matchLoadLocal(hashCodeInvoke.getTarget(), strVarStore.getVariable()) != null);
        Switch realSwitch = (Switch)synSwitch.getNextSibling();
        Int2ObjectOpenHashMap stringLookup = new Int2ObjectOpenHashMap();
        Iterator<SwitchTable.SwitchSection> iterator = synSwitch.getSwitchTable().sections.iterator();
        while (iterator.hasNext()) {
            section = iterator.next();
            assert (((SwitchTable.SwitchSection)section).values.size() == 1);
            if (((Instruction)((SwitchTable.SwitchSection)section).values.first()).opcode == InsnOpcode.NOP) continue;
            this.collectSyntheticIds((Int2ObjectMap<LdcString>)stringLookup, synVar, ((Branch)((SwitchTable.SwitchSection)section).getBody()).getTargetBlock());
        }
        SwitchTable.SwitchSection defaultSection = null;
        realSwitch.getValue().replaceWith(strVarStore.getValue());
        section = realSwitch.getSwitchTable().sections.iterator();
        while (section.hasNext()) {
            SwitchTable.SwitchSection section2 = (SwitchTable.SwitchSection)section.next();
            Iterator<Instruction> iterator2 = section2.values.iterator();
            while (iterator2.hasNext()) {
                Instruction value = iterator2.next();
                if (value.opcode == InsnOpcode.NOP) {
                    defaultSection = section2;
                    continue;
                }
                LdcNumber ldc = (LdcNumber)value;
                LdcString stringVal = (LdcString)stringLookup.remove(ldc.intValue());
                assert (stringVal != null) : "Duplicate synthetic switch id.";
                ldc.replaceWith(stringVal);
            }
        }
        if (!stringLookup.isEmpty()) {
            assert (defaultSection != null);
            FastStream toAdd = FastStream.of((Iterable)stringLookup.int2ObjectEntrySet()).sorted(Comparator.comparingInt(Int2ObjectMap.Entry::getIntKey)).map(Map.Entry::getValue);
            defaultSection.values.addAllFirst((Iterable<Instruction>)toAdd);
        }
        synSwitch.remove();
        assert (strVar.getLoadCount() == 0 && strVar.getStoreCount() == 1);
        assert (synVar.getLoadCount() == 0 && synVar.getStoreCount() == 1);
        synVarStore.remove();
        strVarStore.remove();
    }

    private void collectSyntheticIds(Int2ObjectMap<LdcString> stringLookup, LocalVariable synVar, Block block) {
        IfInstruction ifInsn = (IfInstruction)block.instructions.first();
        Invoke invoke = (Invoke)ifInsn.getCondition();
        LdcString ldcString = (LdcString)invoke.getArguments().first();
        Store sectionStore = (Store)((Block)ifInsn.getTrueInsn()).instructions.first();
        assert (sectionStore.getVariable() == synVar);
        LdcString prev = (LdcString)stringLookup.put(((LdcNumber)sectionStore.getValue()).intValue(), (Object)ldcString);
        assert (prev == null) : "Duplicate synthetic switch id.";
        if (ifInsn.getFalseInsn().opcode != InsnOpcode.NOP) {
            this.collectSyntheticIds(stringLookup, synVar, (Block)ifInsn.getFalseInsn());
        }
    }

    @Nullable
    private static Invoke matchInvokeStringHashcode(Instruction value) {
        Invoke invoke = InvokeMatching.matchInvoke(value, Invoke.InvokeKind.VIRTUAL);
        if (invoke == null) {
            return null;
        }
        Method method = invoke.getMethod();
        if (!TypeSystem.isString(method.getDeclaringClass())) {
            return null;
        }
        if (!method.getName().equals("hashCode")) {
            return null;
        }
        return invoke;
    }
}

