/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers.statement;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.Cast;
import net.covers1624.coffeegrinder.bytecode.insns.Compare;
import net.covers1624.coffeegrinder.bytecode.insns.Comparison;
import net.covers1624.coffeegrinder.bytecode.insns.LogicAnd;
import net.covers1624.coffeegrinder.bytecode.insns.LogicNot;
import net.covers1624.coffeegrinder.bytecode.insns.LogicOr;
import net.covers1624.coffeegrinder.bytecode.insns.Ternary;
import net.covers1624.coffeegrinder.bytecode.matching.LdcMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LogicMatching;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.TransformContextBase;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.None;

public class ExpressionTransforms
extends SimpleInsnVisitor<TransformContextBase>
implements StatementTransformer {
    private static final ExpressionTransforms INSTANCE = new ExpressionTransforms();

    public static void runOnExpression(Instruction statement, TransformContextBase ctx) {
        statement.accept(INSTANCE, ctx);
    }

    @Override
    public void transform(Instruction statement, StatementTransformContext ctx) {
        statement.accept(this, ctx);
    }

    @Override
    public None visitBlock(Block block, TransformContextBase ctx) {
        return NONE;
    }

    @Override
    public None visitCheckCast(Cast cast, TransformContextBase ctx) {
        Cast innerCast;
        if (cast.getArgument().opcode == InsnOpcode.CHECK_CAST && (innerCast = (Cast)cast.getArgument()).getType() == cast.getType()) {
            ctx.pushStep("Remove duplicate cast");
            cast = cast.replaceWith(innerCast);
            ctx.popStep();
        }
        return (None)super.visitCheckCast(cast, ctx);
    }

    @Override
    public None visitComparison(Comparison comparison, TransformContextBase ctx) {
        if (comparison.getLeft() instanceof Compare) {
            Compare left = (Compare)comparison.getLeft();
            assert (LdcMatching.matchLdcInt(comparison.getRight(), 0) != null);
            ctx.pushStep("Unwrap NaN comparison");
            comparison = comparison.replaceWith(new Comparison(comparison.getKind(), left.getLeft(), left.getRight()));
            if (!ExpressionTransforms.isValidNaNComparison(left.getKind(), comparison.getKind())) {
                comparison.setKind(comparison.getKind().negate());
                comparison.replaceWith(new LogicNot(comparison));
            }
            ctx.popStep();
            comparison.accept(this, ctx);
            return NONE;
        }
        return (None)super.visitComparison(comparison, ctx);
    }

    private static boolean isValidNaNComparison(Compare.Kind nanKind, Comparison.ComparisonKind kind) {
        if (nanKind == Compare.Kind.NAN_L) {
            return kind != Comparison.ComparisonKind.LESS_THAN && kind != Comparison.ComparisonKind.LESS_THAN_EQUAL;
        }
        if (nanKind == Compare.Kind.NAN_G) {
            return kind != Comparison.ComparisonKind.GREATER_THAN && kind != Comparison.ComparisonKind.GREATER_THAN_EQUAL;
        }
        return true;
    }

    @Override
    public None visitTernary(Ternary ternary, TransformContextBase ctx) {
        ternary.getTrueInsn().accept(this, ctx);
        ternary.getFalseInsn().accept(this, ctx);
        if (this.unwrapBooleanOperator(ternary, ctx)) {
            return NONE;
        }
        ternary.getCondition().accept(this, ctx);
        return NONE;
    }

    @Override
    public None visitLogicNot(LogicNot logicNot, TransformContextBase ctx) {
        Instruction arg = logicNot.getArgument();
        LogicNot nestedNot = LogicMatching.matchLogicNot(arg);
        if (nestedNot != null) {
            ctx.pushStep("Unwrap not chain");
            Instruction repl = logicNot.replaceWith(nestedNot.getArgument());
            ctx.popStep();
            repl.accept(this, ctx);
            return NONE;
        }
        if (arg instanceof Comparison) {
            boolean isFloatComparison;
            Comparison comp = (Comparison)arg;
            AType leftType = comp.getLeft().getResultType();
            AType rightType = comp.getRight().getResultType();
            boolean bl = isFloatComparison = leftType == PrimitiveType.FLOAT || leftType == PrimitiveType.DOUBLE || rightType == PrimitiveType.FLOAT || rightType == PrimitiveType.DOUBLE;
            if (!isFloatComparison || comp.getKind() == Comparison.ComparisonKind.EQUAL || comp.getKind() == Comparison.ComparisonKind.NOT_EQUAL) {
                ctx.pushStep("Push negation into comparison");
                comp.setKind(comp.getKind().negate());
                comp.setOffsets(logicNot);
                logicNot.replaceWith(comp);
                ctx.popStep();
            }
            comp.accept(this, ctx);
            return NONE;
        }
        if (arg.opcode == InsnOpcode.LOGIC_AND) {
            ctx.pushStep("Push inversion into logic and");
            LogicAnd and = (LogicAnd)arg;
            LogicOr or = logicNot.replaceWith(new LogicOr(new LogicNot(and.getLeft()), new LogicNot(and.getRight())));
            or.accept(this, ctx);
            ctx.popStep();
            return NONE;
        }
        if (arg.opcode == InsnOpcode.LOGIC_OR) {
            ctx.pushStep("Push inversion into logic or");
            LogicOr or = (LogicOr)arg;
            LogicAnd and = logicNot.replaceWith(new LogicAnd(new LogicNot(or.getLeft()), new LogicNot(or.getRight())));
            and.accept(this, ctx);
            ctx.popStep();
            return NONE;
        }
        arg.accept(this, ctx);
        return NONE;
    }

    public boolean unwrapBooleanOperator(Ternary ternary, TransformContextBase ctx) {
        if (ternary.getParent() instanceof Block) {
            return false;
        }
        if (LdcMatching.matchLdcBoolean(ternary.getTrueInsn(), true) != null && LdcMatching.matchLdcBoolean(ternary.getFalseInsn(), false) != null) {
            ctx.pushStep("Unwrap if cond ? true : false");
            ternary.replaceWith(ternary.getCondition()).accept(this, ctx);
            ctx.popStep();
            return true;
        }
        if (LdcMatching.matchLdcBoolean(ternary.getFalseInsn(), false) != null && LdcMatching.matchLdcBoolean(ternary.getTrueInsn(), true) != null) {
            ctx.pushStep("Unwrap if cond ? false : true");
            LogicNot replacement = new LogicNot(ternary.getCondition());
            ternary.replaceWith(replacement);
            ctx.popStep();
            ((Instruction)replacement).accept(this, ctx);
            return true;
        }
        return false;
    }
}

