/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers.statement;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Cast;
import net.covers1624.coffeegrinder.bytecode.insns.FieldReference;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Reference;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.tags.IIncTag;
import net.covers1624.coffeegrinder.bytecode.insns.tags.InsnTag;
import net.covers1624.coffeegrinder.bytecode.insns.tags.PotentialConstantLookupTag;
import net.covers1624.coffeegrinder.bytecode.matching.AssignmentMatching;
import net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformer;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.IntegerConstantType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public class Inlining
implements StatementTransformer {
    @Override
    public void transform(Instruction statement, StatementTransformContext ctx) {
        Store store = LoadStoreMatching.matchStoreLocal(statement);
        if (store == null) {
            return;
        }
        LocalVariable v = store.getVariable();
        if (v.getStoreCount() != 1) {
            return;
        }
        if (!v.isSynthetic()) {
            return;
        }
        if (v.getLoadCount() == 0 && v.getKind() == LocalVariable.VariableKind.STACK_SLOT) {
            ctx.pushStep("Remove redundant stack store " + v.getUniqueName());
            store.replaceWith(store.getValue());
            ctx.popStep();
            return;
        }
        if (v.getLoadCount() != 1) {
            return;
        }
        Instruction inlinedExpression = store.getValue();
        Load inlineTarget = (Load)((LocalReference)FastStream.of(v.getReferences()).filter(Reference::isReadFrom).only()).getParent();
        LinkedList<Runnable> extraTransforms = new LinkedList<Runnable>();
        if (v.getKind() == LocalVariable.VariableKind.STACK_SLOT ? Inlining.matchWithPotentialInline(store.getNextSiblingOrNull(), extraTransforms, ctx, e -> this.matchLoadIn((Instruction)e, inlineTarget)) == null : !this.loadIsFirstOpIn(store.getNextSiblingOrNull(), inlineTarget)) {
            return;
        }
        ctx.pushStep("Inline variable " + v.getUniqueName());
        extraTransforms.forEach(Runnable::run);
        inlinedExpression.setOffsets(inlineTarget);
        inlinedExpression.setOffsets(store);
        inlineTarget.replaceWith(inlinedExpression);
        this.insertCastForIntegerConstantIfNecessary(inlinedExpression, v.getType(), ctx);
        store.remove();
        ctx.popStep();
    }

    private void insertCastForIntegerConstantIfNecessary(Instruction expr, AType type, StatementTransformContext ctx) {
        if (expr.getParent().opcode == InsnOpcode.STORE) {
            return;
        }
        if (!(expr.getResultType() instanceof IntegerConstantType) || TypeSystem.isAssignableTo(PrimitiveType.INT, type)) {
            return;
        }
        ctx.pushStep("Add cast");
        expr.replaceWith(new Cast(expr, type));
        ctx.popStep();
    }

    private boolean loadIsFirstOpIn(@Nullable Instruction e, Load inlineTarget) {
        if (BranchLeaveMatching.matchReturn(inlineTarget.getParent()) == e) {
            return true;
        }
        FieldReference fieldRef = LoadStoreMatching.matchFieldRef(inlineTarget.getParent());
        return fieldRef != null && AssignmentMatching.matchCompoundAssignment(fieldRef.getParent()) == e;
    }

    @Nullable
    private Instruction matchLoadIn(Instruction e, Load inlineTarget) {
        return inlineTarget.isDescendantOf(e) ? e : null;
    }

    @Nullable
    public static <T> T matchWithPotentialInline(@Nullable Instruction insn, List<Runnable> extraTransforms, MethodTransformContext ctx, Function<Instruction, @Nullable T> matcher) {
        if (insn == null) {
            return null;
        }
        T matched = matcher.apply(insn);
        if (matched != null) {
            return matched;
        }
        if (!Inlining.canInlineIfRequired(insn, extraTransforms, ctx)) {
            return null;
        }
        return matcher.apply(insn.getNextSiblingOrNull());
    }

    public static boolean canInlineIfRequired(Instruction expr, List<Runnable> extraInliningTasks, MethodTransformContext ctx) {
        if (expr.getNextSiblingOrNull() == null) {
            return false;
        }
        if (Inlining.canInlineIInc(expr, extraInliningTasks, ctx)) {
            return true;
        }
        return Inlining.canInlinePotentialConstantLookup(expr, extraInliningTasks, ctx);
    }

    private static boolean canInlineIInc(Instruction expr, List<Runnable> extraInliningTasks, MethodTransformContext ctx) {
        if (!(expr.getTag() instanceof IIncTag)) {
            return false;
        }
        Load potentialInline = ((IIncTag)expr.getTag()).potentialInline;
        if (potentialInline == null) {
            return false;
        }
        extraInliningTasks.add(() -> {
            ctx.pushStep("Inline iinc");
            potentialInline.replaceWith(expr);
            ctx.popStep();
        });
        return true;
    }

    private static boolean canInlinePotentialConstantLookup(Instruction expr, List<Runnable> extraInliningTasks, MethodTransformContext ctx) {
        Invoke invoke;
        InsnTag tag = expr.getTag();
        if (!(tag instanceof PotentialConstantLookupTag)) {
            return false;
        }
        PotentialConstantLookupTag constantTag = (PotentialConstantLookupTag)tag;
        Object ldcValue = Objects.requireNonNull(constantTag.ldc.getRawValue());
        Instruction target = constantTag.isStatic ? expr : ((invoke = (Invoke)expr).getKind() == Invoke.InvokeKind.STATIC ? (Instruction)invoke.getArguments().first() : ((Invoke)expr).getTarget());
        Field constantField = ((ClassType)target.getResultType()).findConstant(ldcValue, constantTag.isStatic);
        if (constantField == null) {
            expr.setTag(null);
            return false;
        }
        assert (constantTag.ldc.isConnected());
        extraInliningTasks.add(() -> {
            ctx.pushStep("Inline constant lookup");
            constantTag.ldc.replaceWith(new Load(new FieldReference(constantField, target)));
            if (expr != target) {
                expr.remove();
            }
            ctx.popStep();
        });
        return true;
    }
}

