/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.AnnotationData;
import net.covers1624.coffeegrinder.type.TypeAnnotationData;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.type.asm.AnnotationParser;
import net.covers1624.coffeegrinder.type.asm.TypeAnnotationParser;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.TypeReference;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.TypeAnnotationNode;

public class AnnotationSupplier {
    public static final AnnotationSupplier EMPTY = new AnnotationSupplier(null, (Iterable<AnnotationNode>)FastStream.of(), (Iterable<TypeAnnotationNode>)FastStream.of());
    private final TypeResolver typeResolver;
    private final List<AnnotationNode> annotations;
    private final List<TypeAnnotationNode> typeAnnotations;

    public AnnotationSupplier(TypeResolver typeResolver, Iterable<AnnotationNode> annotations, Iterable<TypeAnnotationNode> typeAnnotations) {
        this.typeResolver = typeResolver;
        this.annotations = Lists.newArrayList(annotations);
        this.typeAnnotations = Lists.newArrayList(typeAnnotations);
    }

    public List<AnnotationData> getAnnotations() {
        return this.getAnnotations(TypeAnnotationData.EMPTY);
    }

    public List<AnnotationData> getAnnotations(TypeAnnotationData excludes) {
        ArrayList<AnnotationData> annotations = new ArrayList<AnnotationData>(this.annotations.size());
        this.parseAnnotations(annotations, excludes);
        return annotations;
    }

    public void parseAnnotations(List<AnnotationData> destination, TypeAnnotationData excludes) {
        AnnotationParser.parseNodes(this.typeResolver, excludes.getLeftMost(), this.annotations, destination::add);
    }

    public TypeAnnotationData getTypeAnnotations(TypeAnnotationLocation location, AType type) {
        return this.getTypeAnnotations(location, type, 0);
    }

    public TypeAnnotationData getTypeAnnotations(TypeAnnotationLocation location, @Nullable AType type, int index) {
        if (this.typeAnnotations.isEmpty()) {
            return TypeAnnotationData.EMPTY;
        }
        TypeAnnotationData rootNode = new TypeAnnotationData();
        this.parseTypeAnnotations(rootNode, location, type, index);
        return rootNode;
    }

    public void parseTypeAnnotations(TypeAnnotationData rootNode, TypeAnnotationLocation location, @Nullable AType type, int index) {
        for (TypeAnnotationNode node : this.typeAnnotations) {
            if (!location.filter.matches(new TypeReference(node.typeRef), index)) continue;
            TypeAnnotationParser.parseTypeAnnotation(this.typeResolver, type, node, rootNode);
        }
    }

    public boolean isEmpty() {
        return this.annotations.isEmpty() && this.typeAnnotations.isEmpty();
    }

    public boolean equals(AnnotationSupplier other) {
        return this.annotations.equals(other.annotations) && this.typeAnnotations.equals(other.typeAnnotations);
    }

    public static interface LocationFilter {
        public boolean matches(TypeReference var1, int var2);
    }

    public static enum TypeAnnotationLocation {
        CLASS_EXTENDS((t, i) -> t.getSort() == 16 && t.getSuperTypeIndex() == -1),
        CLASS_INTERFACE((t, i) -> t.getSort() == 16 && t.getSuperTypeIndex() == i),
        METHOD_RETURN((t, i) -> t.getSort() == 20),
        METHOD_RECEIVER((t, i) -> t.getSort() == 21),
        METHOD_THROWS((t, i) -> t.getSort() == 23 && t.getExceptionIndex() == i),
        PARAMETER((t, i) -> t.getSort() == 22 && t.getFormalParameterIndex() == i),
        LOCAL_VARIABLE((t, i) -> t.getSort() == 64),
        FIELD((t, i) -> t.getSort() == 19),
        TYPE_PARAMETER((t, i) -> (t.getSort() == 0 || t.getSort() == 1) && t.getTypeParameterIndex() == i),
        TYPE_PARAMETER_BOUND((t, i) -> (t.getSort() == 17 || t.getSort() == 18) && t.getTypeParameterIndex() == i);

        public final LocationFilter filter;

        private TypeAnnotationLocation(LocationFilter filter) {
            this.filter = filter;
        }
    }
}

