/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.quack.collection.FastStream;

public class ArrayType
extends ReferenceType {
    private final TypeResolver typeResolver;
    private final AType elementType;
    private final ClassType superClass;
    private final List<ClassType> directSuperTypes;

    protected ArrayType(TypeResolver typeResolver, AType elementType) {
        this.typeResolver = typeResolver;
        this.elementType = elementType;
        this.superClass = typeResolver.resolveClass(TypeResolver.OBJECT_TYPE);
        this.directSuperTypes = ImmutableList.of((Object)this.superClass, (Object)typeResolver.resolveClass(TypeResolver.CLONEABLE_TYPE), (Object)typeResolver.resolveClass(TypeResolver.SERIALIZABLE_TYPE));
    }

    protected ArrayType(TypeResolver typeResolver, AType elementType, ClassType superClass, List<ClassType> directSuperTypes) {
        this.typeResolver = typeResolver;
        this.elementType = elementType;
        this.superClass = superClass;
        this.directSuperTypes = directSuperTypes;
    }

    public ArrayType withElementType(AType elementType) {
        if (elementType == this.elementType) {
            return this;
        }
        return new ArrayType(this.typeResolver, elementType, this.superClass, this.directSuperTypes);
    }

    public AType getElementType() {
        return this.elementType;
    }

    @Override
    public ReferenceType getSuperType() {
        return this.superClass;
    }

    public FastStream<ClassType> getDirectSuperTypes() {
        return FastStream.of(this.directSuperTypes);
    }

    @Override
    public String getName() {
        return this.elementType.getName() + "[]";
    }

    @Override
    public String getFullName() {
        return this.elementType.getFullName() + "[]";
    }

    public String toString() {
        return this.getFullName();
    }

    @Override
    public boolean mentions(ReferenceType type) {
        return super.mentions(type) || this.elementType instanceof ReferenceType && this.elementType.mentions(type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayType)) {
            return false;
        }
        ArrayType other = (ArrayType)o;
        return this.getElementType().equals(other.getElementType());
    }

    public int hashCode() {
        return this.elementType.hashCode();
    }
}

