/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.IntegerConstantType;
import net.covers1624.quack.collection.FastStream;

public class IntegerConstantUnion
extends AType {
    private final List<IntegerConstantType> types;

    public IntegerConstantUnion(List<IntegerConstantType> types) {
        this.types = ImmutableList.copyOf(types);
        assert (types.size() > 1);
        assert (new HashSet<IntegerConstantType>(types).size() == types.size());
    }

    @Override
    public String getName() {
        return FastStream.of(this.types).map(AType::getName).join(" | ");
    }

    @Override
    public String getFullName() {
        return FastStream.of(this.types).map(AType::getFullName).join(" | ");
    }

    public List<IntegerConstantType> getTypes() {
        return this.types;
    }

    public String toString() {
        return "IntegerConstantUnion(" + FastStream.of(this.types).map(Object::toString).join(" | ") + ")";
    }
}

