/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.Parameter;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeParameter;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import net.covers1624.quack.collection.FastStream;
import org.objectweb.asm.Type;

public class RawMethod
extends Method {
    private final Method decl;
    private final AType returnType;
    private final List<ReferenceType> exceptions;
    private final List<Parameter> parameters;

    public RawMethod(Method decl, AType returnType, List<ReferenceType> exceptions) {
        this.decl = decl;
        this.parameters = FastStream.of(decl.getParameters()).map(p -> new Parameter(p.getName(), this, Objects.requireNonNull(p.getRawType()), null, p.getFlags())).toImmutableList();
        this.returnType = returnType;
        this.exceptions = exceptions;
    }

    @Override
    public Type getDescriptor() {
        return this.decl.getDescriptor();
    }

    @Override
    public Object getDefaultAnnotationValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassType getDeclaringClass() {
        return this.decl.getDeclaringClass();
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public AType getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean isConstructor() {
        return this.decl.isConstructor();
    }

    @Override
    public EnumBitSet<AccessFlag> getAccessFlags() {
        return this.decl.getAccessFlags();
    }

    @Override
    public List<ReferenceType> getExceptions() {
        return this.exceptions;
    }

    @Override
    public Method asRaw() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.decl.getName();
    }

    @Override
    public List<TypeParameter> getTypeParameters() {
        return ImmutableList.of();
    }

    @Override
    public Method getDeclaration() {
        return this.decl;
    }
}

