/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.quack.collection.FastStream;

public class ReferenceUnionType
extends ReferenceType {
    private final List<ReferenceType> types;
    private final ReferenceType superType;

    ReferenceUnionType(List<ReferenceType> types) {
        this.types = ImmutableList.copyOf(types);
        this.superType = TypeSystem.lub(types.toArray(new ReferenceType[0]));
        assert (types.size() > 1);
    }

    @Override
    public String getName() {
        return FastStream.of(this.types).map(AType::getName).join(" | ");
    }

    @Override
    public String getFullName() {
        return FastStream.of(this.types).map(AType::getFullName).join(" | ");
    }

    public List<ReferenceType> getTypes() {
        return this.types;
    }

    @Override
    public ReferenceType getSuperType() {
        return this.superType;
    }

    public String toString() {
        return "ReferenceUnionType(" + FastStream.of(this.types).map(Object::toString).join(" | ") + ")";
    }
}

