/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.util.jvm;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.covers1624.coffeegrinder.util.resolver.ClassResolver;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public class JVMUtils {
    private static final String JAVA_CLASS_PATH = "java.class.path";
    private static final String JAVA_BOOT_CLASS_PATH = "sun.boot.class.path";

    public static void addRuntimeJREToResolver(ClassResolver resolver) {
        JVMUtils.getRuntimeJREPaths().forEach(resolver::addResolver);
    }

    public static List<Path> getRuntimeJREPaths() {
        List<Path> paths = JVMUtils.listSysProp(JAVA_BOOT_CLASS_PATH);
        if (paths == null) {
            paths = JVMUtils.listJMods();
        }
        return paths;
    }

    public static void addRuntimeClasspathToResolver(ClassResolver resolver) {
        List<Path> paths = JVMUtils.listSysProp(JAVA_CLASS_PATH);
        if (paths != null) {
            paths.forEach(resolver::addResolver);
        }
    }

    @Nullable
    private static List<Path> listSysProp(String sysProp) {
        String value = System.getProperty(sysProp);
        if (value == null) {
            return null;
        }
        return FastStream.of((Object[])value.split(File.pathSeparator)).distinct().map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).toList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Path> listJMods() {
        String javaHomeProp = System.getProperty("java.home");
        if (javaHomeProp == null) {
            throw new IllegalStateException("Incompatible runtime: 'java.home' system property is missing.");
        }
        Path javaHome = Paths.get(javaHomeProp, new String[0]);
        if (Files.notExists(javaHome, new LinkOption[0])) {
            throw new IllegalStateException("Incompatible runtime: 'java.home' system property resolves to non-existent path.");
        }
        Path jModFolder = javaHome.resolve("jmods");
        if (Files.notExists(jModFolder, new LinkOption[0])) {
            throw new IllegalStateException("Incompatible runtime: '${java.home}/jmods' does not exist.");
        }
        try (Stream<Path> files = Files.list(jModFolder);){
            List<Path> list = files.collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to list jmods directory.");
        }
    }
}

