/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.util.resolver;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Stream;
import net.covers1624.coffeegrinder.util.resolver.Resolver;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPathResolver
implements Resolver {
    protected final Path path;
    @Nullable
    protected Set<String> files;

    protected AbstractPathResolver(Path path) {
        this.path = path;
        this.validate();
    }

    protected abstract void validate();

    protected Path getRootPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Set<String> getFiles() {
        if (this.files == null) {
            AbstractPathResolver abstractPathResolver = this;
            synchronized (abstractPathResolver) {
                if (this.files != null) {
                    return this.files;
                }
                ImmutableSet.Builder builder = ImmutableSet.builder();
                this.collectFiles(this.getRootPath(), (ImmutableSet.Builder<String>)builder);
                this.files = builder.build();
            }
        }
        return this.files;
    }

    private void collectFiles(Path path, ImmutableSet.Builder<String> files) {
        block15: {
            if (Files.isDirectory(path, new LinkOption[0])) {
                try (Stream<Path> stream = Files.list(path);){
                    stream.forEach(e -> this.collectFiles((Path)e, files));
                    break block15;
                }
                catch (IOException ex) {
                    throw new RuntimeException("Failed to list directory.", ex);
                }
            }
            files.add((Object)StringUtils.stripStart((String)this.getRootPath().relativize(path).toString().replace("\\", "/"), (String)"/"));
        }
    }

    @Override
    public byte @Nullable [] getResource(String name) throws IOException {
        if (!this.hasResource(name)) {
            return null;
        }
        try (InputStream is = Files.newInputStream(this.getRootPath().resolve(name), new OpenOption[0]);){
            byte[] byArray = IOUtils.toBytes((InputStream)is);
            return byArray;
        }
    }

    @Override
    public boolean hasResource(String name) {
        return this.getFiles().contains(name);
    }

    @Override
    public FastStream<String> getAllClasses() {
        return FastStream.of(this.getFiles()).filter(e -> e.endsWith(".class")).map(e -> e.replace(".class", ""));
    }

    @Override
    public FastStream<String> getAllResources() {
        return FastStream.of(this.getFiles()).filterNot(e -> e.endsWith(".class"));
    }
}

