package net.covers1624.coffeegrinder.bytecode;

import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 19/4/21.
 */
public class SemanticHelper {

    /**
     * Combines the flags of a branch.
     * <p>
     * The returned flags are effectively or'd together, but will only contain {@link InstructionFlag#END_POINT_UNREACHABLE}
     * if both branches contain that flag.
     *
     * @param trueFlags  The True branch flags.
     * @param falseFlags The False branch flags.
     * @return The combined flags.
     */
    public static EnumBitSet<InstructionFlag> combineBranches(EnumBitSet<InstructionFlag> trueFlags, EnumBitSet<InstructionFlag> falseFlags) {
        EnumBitSet<InstructionFlag> flags = trueFlags.copy();
        flags.or(falseFlags);

        // the endpoint of the 'if' is only unreachable if both branches have an unreachable endpoint
        if (trueFlags.get(InstructionFlag.END_POINT_UNREACHABLE) != falseFlags.get(InstructionFlag.END_POINT_UNREACHABLE)) {
            flags.clear(InstructionFlag.END_POINT_UNREACHABLE);
        }

        return flags;
    }
}
