package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import org.jetbrains.annotations.Nullable;

/**
 * Created by covers1624 on 7/12/21.
 */
public class FieldReference extends Reference {

    @Nullable
    private final ClassType targetClassType;
    private Field field;
    private final InstructionSlot<Instruction> target = new InstructionSlot<>(this);

    public FieldReference(Field field) {
        this(field, new Nop());
    }

    public FieldReference(Field field, Instruction target) {
        this(null, field, target);
    }

    public FieldReference(@Nullable ClassType targetClassType, Field field, Instruction target) {
        super(InsnOpcode.FIELD_REFERENCE);
        this.targetClassType = targetClassType;
        this.field = field;
        this.target.set(target);
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        // this.field cannot throw, this can never be null
        if (getTarget().opcode == InsnOpcode.LOAD_THIS) return InstructionFlag.NONE;
        return InstructionFlag.MAY_THROW.toSet();
    }

    @Override
    public AType getType() {
        return field.getType();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitFieldReference(this, ctx);
    }

    @Override
    public FieldReference copy() {
        return new FieldReference(targetClassType, field, getTarget().copy());
    }

    @Nullable
    public ClassType getTargetClassType() {
        return targetClassType;
    }

    public Instruction getTarget() {
        return target.get();
    }

    public Field getField() {
        return field;
    }

    public void setField(Field field) {
        this.field = field;
    }
}
