package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 16/7/21.
 */
public class InvokeDynamic extends Instruction {

    private final AType resultType;
    public final String name;
    public final Method bootstrapHandle;
    public final Object[] bootstrapArguments;

    public final IndexedInstructionCollection<Instruction> arguments = new IndexedInstructionCollection<>(this);

    public InvokeDynamic(AType resultType, String name, Method bootstrapHandle, Object[] bootstrapArguments, Iterable<Instruction> arguments) {
        super(InsnOpcode.INVOKE_DYNAMIC);
        this.resultType = resultType;
        this.name = name;
        this.bootstrapHandle = bootstrapHandle;
        this.bootstrapArguments = bootstrapArguments;

        this.arguments.setValues(arguments);
    }

    @Override
    public AType getResultType() {
        return resultType;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.MAY_THROW.toSet();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitInvokeDynamic(this, ctx);
    }
}
