package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 7/12/21.
 */
public class LocalReference extends Reference {

    public final LocalVariable variable;

    public LocalReference(LocalVariable variable) {
        super(InsnOpcode.LOCAL_REFERENCE);
        this.variable = variable;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public AType getType() {
        return variable.getType();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitLocalReference(this, ctx);
    }

    @Override
    public LocalReference copy() {
        return new LocalReference(variable);
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        variable.addReference(this);
    }

    @Override
    protected void onDisconnected() {
        variable.removeReference(this);
        super.onDisconnected();
    }
}
