package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 30/4/24.
 */
public class LogicAnd extends Instruction {

    private final InstructionSlot<Instruction> left = new InstructionSlot<>(this);
    private final InstructionSlot<Instruction> right = new InstructionSlot<>(this);

    public LogicAnd(Instruction left, Instruction right) {
        super(InsnOpcode.LOGIC_AND);
        this.left.set(left);
        this.right.set(right);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.BOOLEAN;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitLogicAnd(this, ctx);
    }

    public Instruction getLeft() {
        return left.get();
    }

    public Instruction getRight() {
        return right.get();
    }
}
